/* $Id: common.h,v 1.4 2005/02/01 14:32:39 zlb Exp $ */

#define CTEX_VERSION "0.2.9"

#undef USE_TEMPDIR

#ifdef USE_TEMPDIR
#  ifdef UNIX
#    define CTEX_TMP "ctextemp.dir/"
#  else
#    define CTEX_TMP "ctextemp.dir\\"
#  endif
#else
#  define CTEX_TMP "ctextemp_"
#endif

typedef short Boolean;

#define True    1
#define False   0

#ifdef UNIX
#  define fnstrcmp	strcmp
#  define fnstrncmp	strncmp
#else
#  define fnstrcmp	stricmp
#  define fnstrncmp	strnicmp
#endif

#ifdef WIN32
#  ifndef __MINGW32__
#    define PATH_MAX	_MAX_PATH+1
#  endif
#  define getcwd	_getcwd
#  define popen		_popen
#  define pclose	_pclose
#  define chdir		_chdir
#  define mkdir(d, m)	_mkdir(d)
/* not needed with MikTeX/Windows */
#  define getenv(s)	""
#  define setenv(n,v,f)
#  ifdef _DEBUG
#    define DEBUG
#  endif
#endif

#define BASENAME(path, name) {						\
    char *base_tmp;							\
    name = ((name = strrchr(path, '/')) == NULL) ? path :  name + 1;	\
    if ((base_tmp = strrchr(path, '\\')) != NULL && name <= base_tmp)	\
	name = base_tmp + 1;						\
    if ((base_tmp = strrchr(path, ':')) != NULL && name <= base_tmp)	\
	name = base_tmp + 1;						\
}

typedef struct {
    char *orig_fn;
    char *temp_fn;
} fnmap_t;

/* Function protocols */

/* patchchk.c */
int patchdvi_check(char *dvi_name);

/* ctexscan.c */
int ctexscan(const char *fin, const char *flst, Boolean ctx_flag, FILE *fout);
char *get_file_ext(char *fn);

/* dvi.c */
int fnmap_comp(const void *e1, const void *e2);
int patch_dvi_file(const char *fin, const char *fout, fnmap_t *fnmap,
		size_t fnmap_n);
