/* $Id: wedt-yap.c,v 1.2 2004/11/26 11:41:33 zlb Exp $ */

/* Interface for forward/inverse search with WinEdt/yap.

WinEdt
------

In "Options->Menu Setup->Accessories->DVI Search->Macro", change:
	Run(|%$('DVIView'); -1 -s "%!l %p\%n%t" "%P\%N.dvi"|,'%P');
to:
	Run('wedt-yap +%!l "%p\%n%t" "%P\%N.dvi"','%P');


Yap
---

In "View->Options->Inverse Search->Command", enter:

	wedt-yap +%l "%f"

*/

#ifdef UNIX
#  error This code is designed for DOS/Windows
#endif

#ifdef _DEBUG
#  define DEBUG
#endif

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <sys/types.h>
#include <sys/stat.h>

#if defined(WIN32) && !defined(__MINGW32__)
#  define PATH_MAX      _MAX_PATH+1
#else
#  include <limits.h>   /* PATH_MAX */
#endif

#include "fullpath.h"

static char ctex_dir[PATH_MAX + 1];
static char src[PATH_MAX + 1];
static char s[3*PATH_MAX + 128];
static unsigned lineno;

#define inverse	(argc == 3)

int main(int argc, char **argv)
{
    char *p, *base, *ext;
    struct stat buf;

    if (!(argc == 3 || argc == 4) || argv[1][0] != '+') {
	fprintf(stderr, "Usage:\n");
	fprintf(stderr, "\t%s +lineno srcfile\n(yap -> winedt)\n", argv[0]);
	fprintf(stderr, ", or:\n");
	fprintf(stderr, "\t%s +lineno srcfile dvifile\n(winedt -> yap)\n",
		argv[0]);
	return 1;
    }

    /* Figure out the installation directory of CTeX */
    strcpy(ctex_dir, fullpath(argv[0]));
    for (p = ctex_dir; *p != '\0'; p++)
	if (*p == '/') *p = '\\';
    if ((p = strchr(ctex_dir, '\\')) != NULL && (p = strchr(p+1, '\\')) != NULL)
	*p = '\0';

#ifdef DEBUG
    fprintf(stderr, "ctex_dir = %s\n", ctex_dir);
#endif

    lineno = atoi(argv[1] + 1);

    strcpy(src, argv[2]);
    for (p = src; *p != '\0'; p++)
	if (*p == '/') *p = '\\';

    /* find basename of srcfile */
    if ((p = strrchr(src, '\\')) == NULL && (p = strrchr(src, ':')) == NULL)
	base = src;
    else
	base = p + 1;

    /* find the extension of `src' */
    p = src + strlen(src) - 1;
    while (p >= src && *p != '.' && *p != '\\' && *p != ':')
	p--;
    if (p < src || *p != '.')
	p = src + strlen(src);
    ext = p;

#ifdef DEBUG
    fprintf(stderr, "basename = %s, extension = %s\n", base, ext);
#endif

    if (inverse) {	/* yap -> winedt */
	/* strip possible 'ctextemp_' prefix in filename
	   (already handled by patchdvi, but leaving it here won't hurt) */
	if (!strnicmp(base, "ctextemp_", 9))
	    strcpy(base, base + 9);

	/* if extension is .tex and ".ctx" file exists, then change
	   extension to ".ctx" */
	if (!stricmp(ext, ".tex")) {
	    strcpy(s, src);
	    strcpy(s + (ext - src), ".ctx");
#ifdef DEBUG
	    fprintf(stderr, "Checking file \"%s\"...\n", s);
#endif
	    if (stat(s, &buf) == 0)
		strcpy(ext, ".ctx");
	}
    }
    else {		/* winedt -> yap */
	/* if extension is ".ctx", then change to ".tex" */
	if (!stricmp(ext, ".ctx"))
	    strcpy(ext, ".tex");

#if 0	/* handled by patchdvi */
	/* check if we should append ctextemp_ prefix.
	   (note: this is better done by modifying yap). */
	if (strnicmp(base, "ctextemp_", 9)) {
	    strcpy(s, src);
	    strcpy(s + (base - src), "ctextemp_");
	    strcpy(s + (base - src) + 9, base);
#ifdef DEBUG
	    fprintf(stderr, "Checking file \"%s\"...\n", s);
#endif
	    if (stat(s, &buf) == 0)
		strcpy(src, s);
	}
#endif
    }

    /* launch command */
    if (inverse)
	/* Example: "WinEdt.exe" "[Open('srcfile.tex');SelPar(lineno,8)]" */
	sprintf(s, "\"%s\\winedt\\winedt.exe\" "
		   "\"[Open('%s');SelPar(%d,8)]\"", ctex_dir, src, lineno);
    else
	/* Example: yap.exe -1 -s "123 file.tex" "file.dvi" */
	sprintf(s, "\"%s\\texmf\\miktex\\bin\\yap.exe\" -1 -s \"%d %s\" \"%s\"",
		ctex_dir, lineno, base, argv[3]);

#ifdef DEBUG
    fprintf(stderr, "Executing: %s\n", s);
#endif

    return system(s);
}
