#!/bin/bash
#
# $Id: cctmkind-test.sh,v 1.2 2004/11/26 11:41:32 zlb Exp $
#
# Process and compare makeindex/test/*.idx files
#

TEST_DIR=$HOME/makeindex/test

cd $TEST_DIR
mkdir -p makeindex cctmkind
rm -f makeindex/* cctmkind/*

for f in *.idx; do
    echo $f
    cctmkind -q < $f 2>/dev/null \
	| grep '^[ 	]\+\\[a-z]*item' >cctmkind/${f%\.idx}.ind
    makeindex -q < $f 2>/dev/null \
	| grep '^[ 	]\+\\[a-z]*item' >makeindex/${f%\.idx}.ind
done

diff -bur --brief cctmkind makeindex
