/* $Id: cctmkind-specs.h,v 1.2 2004/11/26 11:41:32 zlb Exp $ */

#ifndef XX1
#  define CHAR_T   byte
#  define STRING_T byte *
#  define NUMBER_T int
#  define XX1(spec, flag, var, type, func, arg) extern type var;
#  define AA1(spec, flag, var, type, func, arg)
#  define XX2(spec, flag, var, type, func, arg1, arg2) extern type var[];
#endif

/* List of Makeindex specifiers.
 *
 *  . flag means if the specifier is implemented
 *
 *  . XX1 for specifiers requiring one argument (AA1 for aliases)
 *
 *  . XX2 for specifiers requiring two arguments
 * 
 *  Specifier		 flag  varname           type    function    default value
 *  ---------            -------------           ----    --------    ------------- */
XX1("actual",            True, actual,           CHAR_T,   NULL,       "'@'")
XX1("arg_close",         True, arg_close,        CHAR_T,   NULL,       "'}'")
XX1("arg_open",          True, arg_open,         CHAR_T,   NULL,       "'{'")
XX1("level",             True, level,            CHAR_T,   NULL,       "'!'")
XX1("quote",             True, quote,            CHAR_T,   NULL,       "'\"'")
XX1("range_close",       True, range_close,      CHAR_T,   NULL,       "')'")
XX1("range_open",        True, range_open,       CHAR_T,   NULL,       "'('")

XX1("keyword",           True, keyword,          STRING_T, NULL,       "\\indexentry")

XX1("postamble",         True, postamble,        STRING_T, NULL,       "\n\n\\end{theindex}\n")
XX1("preamble",          True, preamble,         STRING_T, NULL,       "\\begin{theindex}\n")

XX1("delim_0",           True, delim_0,          STRING_T, NULL,       ", ")
XX1("delim_1",           True, delim_1,          STRING_T, NULL,       ", ")
XX1("delim_2",           True, delim_2,          STRING_T, NULL,       ", ")
XX1("delim_n",           True, delim_n,          STRING_T, NULL,       ", ")
XX1("delim_r",           True, delim_r,          STRING_T, NULL,       "--")
XX1("delim_t",           True, delim_t,          STRING_T, NULL,       "")
XX1("suffix_2p",         True, suffix_2p,        STRING_T, NULL,       "")
XX1("suffix_3p",         True, suffix_3p,        STRING_T, NULL,       "")
XX1("suffix_mp",         True, suffix_mp,        STRING_T, NULL,       "")
XX1("encap_infix",       True, encap_infix,      STRING_T, NULL,       "{")
XX1("encap_prefix",      True, encap_prefix,     STRING_T, NULL,       "\\")
XX1("encap_suffix",      True, encap_suffix,     STRING_T, NULL,       "}")
XX1("encap",             True, encap,            CHAR_T,   NULL,       "'|'")
XX1("escape",            True, escape,           CHAR_T,   NULL,       "'\\'")

XX1("group_skip",        True, group_skip,       STRING_T, NULL,       "\n\n  \\indexspace\n")
XX1("heading_prefix",    True, heading_prefix,   STRING_T, NULL,       "")
AA1("lethead_prefix",    True, heading_prefix,   STRING_T, NULL,       "")
XX1("headings_flag",     True, headings_flag,    NUMBER_T, NULL,       "0")
AA1("lethead_flag",      True, headings_flag,    NUMBER_T, NULL,       "0")
XX1("heading_suffix",    True, heading_suffix,   STRING_T, NULL,       "")
AA1("lethead_suffix",    True, heading_suffix,   STRING_T, NULL,       "")

XX1("line_max",          0,    line_max,         NUMBER_T, NULL,       "72")
XX1("indent_length",     0,    indent_length,    NUMBER_T, NULL,       "16")
XX1("indent_space",      0,    indent_space,     STRING_T, NULL,       "\t\t")

XX1("item_01",           True, item_01,          STRING_T, NULL,       "\n    \\subitem ")
XX1("item_0",            True, item_0,           STRING_T, NULL,       "\n  \\item ")
XX1("item_12",           True, item_12,          STRING_T, NULL,       "\n    \\subsubitem ")
XX1("item_1",            True, item_1,           STRING_T, NULL,       "\n     \\subitem ")
XX1("item_2",            True, item_2,           STRING_T, NULL,       "\n       \\subsubitem ")
XX1("item_x1",           True, item_x1,          STRING_T, NULL,       "\n    \\subitem ")
XX1("item_x2",           True, item_x2,          STRING_T, NULL,       "\n    \\subsubitem ")

XX1("numhead_negative",  True, numhead_negative, STRING_T, NULL,       "numbers")
XX1("numhead_positive",  True, numhead_positive, STRING_T, NULL,       "Numbers")
XX1("symhead_negative",  True, symhead_negative, STRING_T, NULL,       "symbols")
XX1("symhead_positive",  True, symhead_positive, STRING_T, NULL,       "Symbols")

XX1("include",           True, include,          STRING_T, do_include, NULL)

XX1("setpage_prefix",    True, setpage_prefix,   STRING_T, NULL,       "\n  \\setcounter{page}{")
XX1("setpage_suffix",    True, setpage_suffix,   STRING_T, NULL,       "}\n")

XX1("page_compositor",   0,    page_compositor,  STRING_T, NULL,       NULL)

XX2("merge_rule",        0,    merge_rule,       STRING_T, NULL,       NULL, NULL)
XX2("sort_group",        0,    sort_group,       STRING_T, NULL,       NULL, NULL)

/* Note: the following specifiers require 2 arguments of different types
 * (NUMBER_T, STRING_T) or (STRING_T, NUMBER_T). We simply store the NUMBER_T
 * argument as STRING_T which will be converted later. For this purpose
 * we must allow unquoted string argument composed of non-space characters 
 * in the function read_token() */
XX2("group_head",        0,    group_head,       STRING_T, NULL,       NULL, NULL)
XX2("sort_rule",         0,    sort_rule,        STRING_T, NULL,       NULL, NULL)

#undef CHAR_T
#undef STRING_T
#undef NUMBER_T
#undef XX1
#undef AA1
#undef XX2
