/* $Id: bmf2tif.h,v 1.2 2004/11/26 11:41:32 zlb Exp $ */

#define TIF_NTAGS	((sizeof(TIFHeader)-30)/12)
#define TAG_LOC(no)	(10+12*no)

#define LBYTE0(i) (byte)(i%256l)
#define LBYTE1(i) (byte)((i/256l)%256l)
#define LBYTE2(i) (byte)((i/65536l)%256l)
#define LBYTE3(i) (byte)((i/16777216l)%256l)

/* entry numbers of interesting tags */
#define TIF_WIDTH	1		/* width */
#define TIF_HEIGHT	2		/* height */
#define TIF_PHOTOMETRIC	5		/* photometric interpretation */
#define TIF_IMAGE	8		/* image loc. tag */
#define TIF_SByteCount	12		/* StripeByteCount */
#define TIF_DPI_X	15		/* dpix */
#define TIF_DPI_Y	16		/* dpiy tag */

#define TIF_DPI_X_LOC	(10+TIF_NTAGS*12+4)
#define TIF_DPI_Y_LOC	(10+TIF_NTAGS*12+12)

byte TIFHeader[]={
  73,73,		/* "II" */
  42,0,			/* version number */
  8,0,0,0,		/* offset to diretory */

  /* directory */
  0,0,			/* # of entries (to be filled out later) */

  255,0,		/* Entry 0 */
  3,0,			/* type short */
  1,0,0,0,		/* length 1 */
  1,0,0,0,		/* value */

  0,1,			/* Entry 1: width */
  3,0,			/* type short */
  1,0,0,0,		/* length 1 */
  140,4,0,0,		/* value */

  1,1,			/* Entry 2: height */
  3,0,
  1,0,0,0,
  50,4,0,0,

  2,1,			/* Entry 3 */
  3,0,
  1,0,0,0,
  1,0,0,0,

  3,1,			/* Entry 4 */
  3,0,
  1,0,0,0,
  1,0,0,0,

  6,1,			/* Entry 5: photometric interpretation */
  3,0,			/* short */
  1,0,0,0,		/* length */
  0,0,0,0,		/* value=0 */

  7,1,			/* Entry 6 */
  3,0,
  1,0,0,0,
  2,0,0,0,

  10,1,			/* Entry 7 */
  3,0,
  1,0,0,0,
  1,0,0,0,

  17,1,			/* Entry 8: image location */
  4,0,
  1,0,0,0,
  86,1,0,0,

  18,1,			/* Entry 9 */
  3,0,
  1,0,0,0,
  1,0,0,0,

  21,1,			/* Entry 10 */
  3,0,
  1,0,0,0,
  1,0,0,0,

  22,1,			/* Entry 11 */
  4,0,
  1,0,0,0,
  50,4,0,0,

  23,1,			/* Entry 12: StripeByteCounts */
  4,0,
  1,0,0,0,
  0,0,0,0,

  24,1,			/* Entry 13 */
  3,0,
  1,0,0,0,
  0,0,0,0,

  25,1,			/* Entry 14 */
  3,0,
  1,0,0,0,
  1,0,0,0,

  26,1,			/* Entry 15: dpix location */
  5,0,
  1,0,0,0,
  70,1,0,0,

  27,1,			/* Entry 16: dpiy location */
  5,0,
  1,0,0,0,
  78,1,0,0,

  28,1,			/* Entry 17 */
  3,0,
  1,0,0,0,
  1,0,0,0,

#if 0	/* --------------------------------------------------------- */
  72,128,		/* Entry 18 */
  3,0,
  1,0,0,0,
  2,0,0,0,

  73,128,		/* Entry 19 */
  3,0,
  1,0,0,0,
  1,0,0,0,

  74,128,		/* Entry 20 */
  3,0,
  1,0,0,0,
  2,0,0,0,

  75,128,		/* Entry 21 */
  3,0,
  1,0,0,0,
  1,0,0,0,

  76,128,		/* Entry 22 */
  4,0,
  1,0,0,0,
  0,0,0,0,

  77,128,		/* Entry 23 */
  4,0,
  1,0,0,0,
  0,0,0,0,

  78,128,		/* Entry 24 */
  1,0,
  0,0,0,0,
  0,0,0,0,

  79,128,		/* Entry 25 */
  3,0,
  1,0,0,0,
  1,0,0,0,
#endif	/* --------------------------------------------------------- */
  0,0,0,0,		/* next directory */

  44,1,0,0,		/* dpix */
  1,0,0,0,
  44,1,0,0,		/* dpiy */
  1,0,0,0
};

#ifdef UNIX
#  define AddFileExtension(outname) strcat(outname,".tif")
#else
#  define AddFileExtension(outname) strcat(strlwr(outname),".tif")
#endif

#define WriteFileHeader(width,height,dpix,dpiy,f_out) { 		\
  unsigned long totalbytes=((width+7)/8)*(long)height;			\
  *((byte *)(TIFHeader+8))=TIF_NTAGS%256;				\
  *((byte *)(TIFHeader+9))=TIF_NTAGS/256;				\
  *((byte *)(TIFHeader+TAG_LOC(TIF_WIDTH)+8))=width%256;		\
  *((byte *)(TIFHeader+TAG_LOC(TIF_WIDTH)+9))=width/256;		\
  *((byte *)(TIFHeader+TAG_LOC(TIF_HEIGHT)+8))=height%256;		\
  *((byte *)(TIFHeader+TAG_LOC(TIF_HEIGHT)+9))=height/256;		\
  *((byte *)(TIFHeader+TAG_LOC(TIF_DPI_X)+8))=TIF_DPI_X_LOC%256;	\
  *((byte *)(TIFHeader+TAG_LOC(TIF_DPI_X)+9))=TIF_DPI_X_LOC/256;	\
  *((byte *)(TIFHeader+TAG_LOC(TIF_DPI_Y)+8))=TIF_DPI_Y_LOC%256;	\
  *((byte *)(TIFHeader+TAG_LOC(TIF_DPI_Y)+9))=TIF_DPI_Y_LOC/256;	\
  *((byte *)(TIFHeader+TAG_LOC(TIF_IMAGE)+8))=sizeof(TIFHeader)%256;	\
  *((byte *)(TIFHeader+TAG_LOC(TIF_IMAGE)+9))=sizeof(TIFHeader)/256;	\
  *((byte *)(TIFHeader+TAG_LOC(TIF_SByteCount)+8))=LBYTE0(totalbytes);	\
  *((byte *)(TIFHeader+TAG_LOC(TIF_SByteCount)+9))=LBYTE1(totalbytes);	\
  *((byte *)(TIFHeader+TAG_LOC(TIF_SByteCount)+10))=LBYTE2(totalbytes);	\
  *((byte *)(TIFHeader+TAG_LOC(TIF_SByteCount)+11))=LBYTE3(totalbytes);	\
  									\
  if (neg_flag) {							\
    *((byte *)(TIFHeader+TAG_LOC(TIF_PHOTOMETRIC)+8))=1;		\
    *((byte *)(TIFHeader+TAG_LOC(TIF_PHOTOMETRIC)+9))=0;		\
  }									\
  									\
  *((byte *)(TIFHeader+TIF_DPI_X_LOC+0))=LBYTE0(dpix);			\
  *((byte *)(TIFHeader+TIF_DPI_X_LOC+1))=LBYTE1(dpix);			\
  *((byte *)(TIFHeader+TIF_DPI_X_LOC+2))=LBYTE2(dpix);			\
  *((byte *)(TIFHeader+TIF_DPI_X_LOC+3))=LBYTE3(dpix);			\
  *((byte *)(TIFHeader+TIF_DPI_X_LOC+4))=0;				\
  *((byte *)(TIFHeader+TIF_DPI_X_LOC+5))=0;				\
  *((byte *)(TIFHeader+TIF_DPI_X_LOC+6))=1;				\
  *((byte *)(TIFHeader+TIF_DPI_X_LOC+7))=0;				\
  									\
  *((byte *)(TIFHeader+TIF_DPI_Y_LOC+0))=LBYTE0(dpiy);			\
  *((byte *)(TIFHeader+TIF_DPI_Y_LOC+1))=LBYTE1(dpiy);			\
  *((byte *)(TIFHeader+TIF_DPI_Y_LOC+2))=LBYTE2(dpiy);			\
  *((byte *)(TIFHeader+TIF_DPI_Y_LOC+3))=LBYTE3(dpiy);			\
  *((byte *)(TIFHeader+TIF_DPI_Y_LOC+4))=0;				\
  *((byte *)(TIFHeader+TIF_DPI_Y_LOC+5))=0;				\
  *((byte *)(TIFHeader+TIF_DPI_Y_LOC+6))=1;				\
  *((byte *)(TIFHeader+TIF_DPI_Y_LOC+7))=0;				\
  									\
  fwrite(TIFHeader,sizeof(TIFHeader),1,f_out);				\
}

#define WriteScanLine(buffer,widthb,f_out) fwrite(buffer,widthb,1,f_out)
