/* $Id: bmf.inc,v 1.2 2004/11/26 11:41:32 zlb Exp $ */

/* We assume that the length of a packed raster line does not exceed
   the length of corresponding unpacked data (this is true for
   BMFPACK.EXE) */

int bmf_width,bmf_widthb,bmf_height,bmf_pack,bmf_xoff,bmf_yoff;
long bmf_dpix,bmf_dpiy;
byte bmf_name[256]="",bmf_line[4096];
int bmf_line_no;
static byte bmf_right_mask;
FILE *bmf_f=NULL;

static long bmf_offset=0l;

void bmf_unpack2 _P3(int, n, register byte *, src, register byte *, dest)
/* unpack a raster line compressed using method 2 */
{
  int i;
  byte *limit=dest+bmf_widthb;
  byte b;

  while (n>0 && dest<limit) {
    b=*(src++); n--;
    if (!(b&128)) {	/* copy next b+1 bytes */
      i=b+1; if (dest+i>limit) i=(int)(limit-dest);
      n-=i;
      switch (i) {
        case 6 :  *(dest++)=*(src++);
        case 5 :  *(dest++)=*(src++);
        case 4 :  *(dest++)=*(src++);
        case 3 :  *(dest++)=*(src++);
        case 2 :  *(dest++)=*(src++);
        case 1 :  *(dest++)=*(src++);
        case 0 :  break;
        default : memcpy(dest,src,i); src+=i; dest+=i; break;
      }
    } else {	/* read next byte which should be repeated -ch+1 times */
#if 0
      if (b==128) continue; 		/* ignored by the printers */
#endif
      i=257-b;
      b=*(src++); n--;
      if (dest+i>limit) i=(int)(limit-dest);
      switch (i) {
        case 6 :  *(dest++)=b;
        case 5 :  *(dest++)=b;
        case 4 :  *(dest++)=b;
        case 3 :  *(dest++)=b;
        case 2 :  *(dest++)=b;
        case 1 :  *(dest++)=b;
        case 0 :  break;
        default : memset(dest,b,i), dest+=i;
      }
    }
  }
  if (dest<limit) memset(dest,0,(int)(limit-dest));
}

void bmf_unpack3 _P3(int, n, register byte *, src, register byte *, dest)
/* unpack a raster line compressed using Delta compression.
  dest contains the last raster line as input */
{
  int step,count;
  byte *limit=dest+bmf_widthb;
  byte b;

  while (n>0 && dest<limit) {
    b=*(src++); n--;
    count=(b>>5)+1; step=b&31;
    if (step==31) do {
      b=*(src++); n--; step+=b;
    } while (b==255);
    if ((dest+=step)>=limit) break;
    if (dest+count>limit) count=(int)(limit-dest);
    /* copy count bytes from src to dest */
    n-=count;
    switch (count) {
      case 6 :  *(dest++)=*(src++);
      case 5 :  *(dest++)=*(src++);
      case 4 :  *(dest++)=*(src++);
      case 3 :  *(dest++)=*(src++);
      case 2 :  *(dest++)=*(src++);
      case 1 :  *(dest++)=*(src++);
      case 0 :  break;
      default : memcpy(dest,src,count), src+=count, dest+=count;
    }
  }
}

int bmf_open _P7(byte *, s, long *, dpix, long *, dpiy, int *, w, int *, h,
                 int *, xoff, int *, yoff)
/* open a BMF file, returns 1 if it is compressed and 0 otherwise.
   Returns -1 if error */
{
  register int i;
  byte b[16];

  if (bmf_f!=NULL) { /* check if the BMF file is already open */
#ifdef UNIX
    if (!strcmp(s,bmf_name)) goto fin;
#else
    if (!stricmp(s,bmf_name)) goto fin;
#endif
    fclose(bmf_f); bmf_f=NULL; bmf_offset=0l;
  }

#ifdef DVI
  if (dba_offset) {
    if ((bmf_f=fopen(dviname,"rb"))!=NULL) {
      /* look for bmf file name "s" */
      struct DBA_ENTRY dba_entry;
      i=strlen(s)-1;
      while (i>=0 && s[i]!='\\' && s[i]!='/') i--;
      strncpy(b,s+i+1,12); b[12]='\0';
      fseek(bmf_f, (long)sizeof(dba_head), SEEK_SET);
      for (i=0; i<dba_head.entries; i++) {
        if (fread(&dba_entry, sizeof(dba_entry), 1, bmf_f)!=1) goto error;
        if (!stricmp(dba_entry.name, b)) break;
      }
      if (i>=dba_head.entries) {
        fclose(bmf_f); bmf_f=NULL; bmf_offset=0l;
      } else {
        bmf_offset=dba_entry.loc;
        if (fseek(bmf_f, bmf_offset, SEEK_SET)) goto error;
      }
    }
  }
  if (bmf_f==NULL) if ((bmf_f=fopen(s,"rb"))==NULL) return(-1);
#else
  if ((bmf_f=fopen(s,"rb"))==NULL) return(-1);
#endif
  if (fread(b,4,1,bmf_f)!=1) {
error:
    fclose(bmf_f); bmf_f=NULL; bmf_offset=0l;
    return(-1);
  }
  if (b[0]!=0xff || b[1]!=0xff || b[2]!=0xff || b[3]!=0xff) {
    fseek(bmf_f,0l+bmf_offset,SEEK_SET); bmf_pack=0;
  } else bmf_pack=1;
  /* read BMF heading */
  if (fread(b,16,1,bmf_f)!=1) goto error;
  bmf_dpix=(((b[0]*256l+b[1])*256l)+b[2])*256l+b[3];
  bmf_dpiy=(((b[4]*256l+b[5])*256l)+b[6])*256l+b[7];
  bmf_width=b[8]*256+b[9];
  bmf_height=b[10]*256+b[11];
  bmf_xoff=b[12]*256+b[13];
  bmf_yoff=b[14]*256+b[15];
  if (bmf_width<=0 || bmf_height<=0) goto error;
  bmf_widthb=(bmf_width+7)/8;
  /* record BMF file name */
  strcpy(bmf_name,s);
  bmf_line_no=bmf_height;
fin:
  *dpix=bmf_dpix, *dpiy=bmf_dpiy;
  *w=bmf_width, *h=bmf_height;
  *xoff=bmf_xoff, *yoff=bmf_yoff;
  /* setup mask for right-edge */
  i=bmf_widthb*8-bmf_width;
  bmf_right_mask=i ? (0xff<<i)&0xff:0xff;
  return(bmf_pack);
}

void bmf_close _VOID
{
  if (bmf_f!=NULL) fclose(bmf_f);
  bmf_f=NULL; bmf_offset=0l;
}

int bmf_get_line _P2(register int, lineno, byte *, buffer)
/* read a raster line. returns !0 if error */
{
  register int n;
  unsigned mode;

  if (bmf_f==NULL || lineno<0 || lineno>=bmf_height) return(1);
  if (lineno==bmf_line_no) {	/* simply copy current line */
    memcpy(buffer,bmf_line,bmf_widthb);
    buffer[bmf_widthb-1]&=bmf_right_mask;
    return(0);
  }
  if (!bmf_pack) {	/* unpacked BMF file */
    if (fseek(bmf_f,16l+lineno*(long)bmf_widthb+bmf_offset,SEEK_SET)) return(-1);
    if (fread(buffer,bmf_widthb,1,bmf_f)!=1) return(-1);
    buffer[bmf_widthb-1]&=bmf_right_mask;
    return(0);
  }
  if (lineno<bmf_line_no) {	/* seek to BOF */
    if (fseek(bmf_f,20l+bmf_offset,SEEK_SET)) goto error;
    memset(bmf_line,0,bmf_widthb);
    bmf_line_no=-1;
  }
  while (bmf_line_no<lineno) {
    /* read & unpack next raster line */
    if (fread(buffer,2,1,bmf_f)!=1) {
error:
      bmf_line_no=bmf_height;
      return(-1);
    }
    mode=buffer[0]+256*buffer[1];
    n=mode%4096; mode/=4096;
    switch (mode) {
      case 0 :	/* unpacked */
        if (n) if (fread(bmf_line,n,1,bmf_f)!=1) goto error;
        if (n<bmf_widthb) memset(bmf_line+n,0,bmf_widthb-n);
        break;
      case 2 :	/* TIFF compression */
        if (n) if (fread(buffer,n,1,bmf_f)!=1) goto error;
        bmf_unpack2(n,buffer,bmf_line);
        break;
      case 3 :	/* Delta compression */
        if (n) if (fread(buffer,n,1,bmf_f)!=1) goto error;
        bmf_unpack3(n,buffer,bmf_line);
        break;
      default :
        goto error;
    }
    bmf_line_no++;
  }
  memcpy(buffer,bmf_line,bmf_widthb);
  buffer[bmf_widthb-1]&=bmf_right_mask;
  return(0);
}
