/* $Id: addtocfg.c,v 1.2 2004/12/25 13:46:51 zlb Exp $ */

#include <stdio.h>
#include <string.h>

static char buffer[65536];

int
main(int argc, char *argv[])
{
    FILE *f;
    int i;

    if (argc < 3) {
	fprintf(stderr, "Usage:\n  %s config_file string [...]\n", argv[0]);
	fprintf(stderr, "Examp:\n  %s c:\\ctex\\localtexmf\\web2c\\updcfg.map "
			"\"# everb\" \"Map corners.map\"\n", argv[0]);
	return 1;
    }

    if ((f = fopen(argv[1], "rt")) != NULL) {
	while (1) {
	    if (fgets(buffer, sizeof(buffer), f) == NULL) break;
	    i = strlen(buffer) - 1;
	    if (i >= 0 && buffer[i] == '\n') buffer[i] = '\0';
	    if (!strcmp(buffer, argv[argc - 1])) {
		fprintf(stderr, "Configuration file already contains "
				"the settings.\n");
		fclose(f);
		return 0;
	    }
	} 
	fclose(f);
    }
    else {
	fprintf(stderr, "Creating new file \"%s\"\n", argv[1]);
    }

    if ((f = fopen(argv[1], "a+t")) == NULL) {
	fprintf(stderr, "Cannot append to file \"%s\", abort.\n", argv[1]);
	return 1;
    }

    fprintf(f, "\n");
    for (i = 2; i < argc; i++) {
	fprintf(stderr, "Appending \"%s\" to %s\n", argv[i], argv[1]);
	fprintf(f, "%s\n", argv[i]);
    }

    fclose(f);
    fprintf(stderr, "Done.\n");

    return 0;
}
