; $Id: CTeX-update.nsi,v 1.11 2004/12/29 00:12:48 zlb Exp $
;
; By SUN Wenchang, 2004/12/25
;
; Nullsoft Scriptable Install System (nsis*.exe) script
; http://nsis.sourceforge.net/
;
;--------------------------------

LoadLanguageFile "${NSISDIR}\Contrib\Language files\SimpChinese.nlf"
LoadLanguageFile "${NSISDIR}\Contrib\Language files\English.nlf"

LangString str1 ${LANG_SIMPCHINESE} "װǰϸĶ˵"
LangString str1 ${LANG_ENGLISH} "Please read carefully the following message"
LangString str2 ${LANG_SIMPCHINESE} ""
LangString str2 ${LANG_ENGLISH} "OK"
LangString str3 ${LANG_SIMPCHINESE} "Ҫ˵"
LangString str3 ${LANG_ENGLISH} "Important Notes"
LangString str4 ${LANG_SIMPCHINESE} "װҪɾ CCT 0.618-4"
LangString str4 ${LANG_ENGLISH} "The installer is about to remove CCT 0.618-4"
LangString str5 ${LANG_SIMPCHINESE} "Ҳ MiKTeX Ŀ¼װ."
LangString str5 ${LANG_ENGLISH} "ERROR: Can not find MiKTeX, the installation is aborted."
LangString str6 ${LANG_SIMPCHINESE} "޷ '$miktexroots' гȡ MiKTeX Ŀ¼."
LangString str6 ${LANG_ENGLISH} "ERROR: Can not extract MiKTeX roots from '$miktexroots'."
LangString str7 ${LANG_SIMPCHINESE} "װļչĿ¼ $tempa:\_temp_ "
LangString str7 ${LANG_ENGLISH} "This will extract files to $tempa:\_temp_"
LangString str8 ${LANG_SIMPCHINESE} "װʹ·װ CCT-0.618-4"
LangString str8 ${LANG_ENGLISH} "The installer will install CCT-0.618-4 using the following paths"
LangString str9 ${LANG_SIMPCHINESE} "װû '$miktexroots' ҵ CCT Ŀ¼."
LangString str9 ${LANG_ENGLISH} "The installer does not find CCT root in '$miktexroots'."

; The name of the installer
Name "CCT 0.618-4 for MiKTex"

; The file to write
OutFile "cct-0.618-4-CTeX-update.exe"


InstallDir $PROGRAMFILES\CCT

Icon CTeX-update.ico
UninstallIcon CTeX-update.ico

; Pages
;--------------------------------
Page license
LicenseText "$(str1)" "$(str2)"
SubCaption 0 "--- $(str3)"
LicenseLangString license ${LANG_SIMPCHINESE} CTeX-update-readme.txt
LicenseLangString license ${LANG_ENGLISH} CTeX-update-readme-en.txt
LicenseData $(license)

Page directory

;--------------------------------
Page instfiles
Var miktexroots            ; MiKTeX install roots
Var texmfroot              ; texmf root
Var localtexmf             ; local texmf root
Var integer1
Var integer2
Var mode
Var tempa
Var tempb
Var CCTrootLen
Var CCTroot
Var scriptpath
;------------------------------------------------------- 
Section ;
   SetOutPath $INSTDIR
   File /r localtexmf\*.*
   
   SetOutPath $INSTDIR$scriptpath
   File  CTeX-update.nsi
   File  CTeX-update.ico
   File  CTeX-update-readme.txt
   File  CTeX-update-readme-en.txt

   WriteRegStr HKLM "Software\CCT" "Version" "0.618-4"
   WriteRegStr HKLM "Software\CCT" "Install Root" "$INSTDIR"
 
   WriteUninstaller $INSTDIR\cct\bin\uninstall.exe
   WriteRegStr HKLM "Software\Microsoft\Windows\CurrentVersion\Uninstall\CCT" \
    "Publisher" "Zhang Lin-bo"
   WriteRegStr HKLM "Software\Microsoft\Windows\CurrentVersion\Uninstall\CCT" \
    "UninstallString" "$INSTDIR\cct\bin\uninstall.exe"
   WriteRegStr HKLM "Software\Microsoft\Windows\CurrentVersion\Uninstall\CCT" \
    "URLUpdateInfo" "ftp://ftp.cc.ac.cn"
   WriteRegStr HKLM "Software\Microsoft\Windows\CurrentVersion\Uninstall\CCT" \
    "Contact" "zlb@lsec.cc.ac.cn"
   WriteRegStr HKLM "Software\Microsoft\Windows\CurrentVersion\Uninstall\CCT" \
    "DisplayName" "CCT-0.618-4"
SectionEnd ; end the section

Section "Uninstall"
 MessageBox MB_OK "$(str4)"
 ReadRegStr $CCTroot HKLM "SOFTWARE\CCT" "Install Root"
 
 RMDir /r $CCTroot\cct
 RMDir /r $CCTroot\tex\latex\cct
 RMDir /r $CCTroot\makeindex\cct
 RMDir /r $CCTroot\fonts\tfm\cct
 RMDir /r $CCTroot\fonts\type1\cct
 RMDir /r $CCTroot\fonts\turetype\cct
 RMDir /r $CCTroot\fonts\afm\cct
 RMDir /r $CCTroot\dvips\cct
 call un.RemoveCCTKey
SectionEnd

Function .onInit
; Look for MiKTeX roots
  ReadRegStr $texmfroot HKLM "SOFTWARE\MiK\MiKTeX\CurrentVersion\MiKTeX" \
    "Install Root"
  ReadRegStr $localtexmf HKLM "SOFTWARE\MiK\MiKTeX\CurrentVersion\MiKTeX" \
    "Local Root"

  StrCmp $texmfroot "" searchroots 
  StrCmp $localtexmf "" searchroots rootsok  
  
searchroots:
  ReadRegStr $miktexroots HKCU "SOFTWARE\MiK\MiKTeX\CurrentVersion\MiKTeX" \
    "Texmf Root Directories"
  StrCmp $miktexroots "" tryhklm foundmiktex
  
tryhklm:
  ReadRegStr $miktexroots HKLM "SOFTWARE\MiK\MiKTeX\CurrentVersion\MiKTeX" \
    "Texmf Root Directories"
  StrCmp $miktexroots "" nomiktex foundmiktex

nomiktex:
  MessageBox MB_OK  "$(str5)"
  Abort
  
foundmiktex:  
 StrLen $integer1  $miktexroots 
 StrCpy $integer2 0   

 loopa:
   StrCpy $texmfroot $miktexroots 1 $integer2
   StrCmp $texmfroot ";" foundlocal
   IntOp  $integer2 $integer2 + 1
   IntCmp $integer2 $integer1 error_mik
   Goto loopa

 error_mik:
   MessageBox MB_OK "$(str6)"  
   Abort
 
 foundlocal:
   StrCpy $localtexmf $miktexroots $integer2 0
   IntOp $integer1 $integer1 - $integer2 
   IntOp $integer1 $integer1 - 1
   IntOp $integer2 $integer2 + 1
   StrCpy $texmfroot $miktexroots $integer1 $integer2
   
   StrCpy  $miktexroots $texmfroot $integer1 0
   StrCpy $integer2 0      
 loopb:
   StrCpy $texmfroot $miktexroots 1 $integer2
   StrCmp $texmfroot ";" foundmain
   IntOp  $integer2 $integer2 + 1
   IntCmp $integer2 $integer1 foundmain
   Goto loopb

 foundmain:  
   StrCpy $texmfroot $miktexroots $integer2 0
   WriteRegStr  HKLM "SOFTWARE\MiK\MiKTeX\CurrentVersion\MiKTeX" \
    "Install Root" "$texmfroot"
   WriteRegStr  HKLM "SOFTWARE\MiK\MiKTeX\CurrentVersion\MiKTeX" \
    "Local Root" "$localtexmf"

rootsok:
;
; Check the command line
; 
;
 StrLen $integer1  $CMDLINE 
 StrCpy $integer2 0   

checkcmdline:
   StrCpy $tempa $CMDLINE 2 $integer2
   StrCmp $tempa "/e"  extractmode
   IntOp  $integer2 $integer2 + 1
   IntCmp $integer2 $integer1 installmode
   Goto checkcmdline

extractmode: 
  StrCpy $mode 1
  IntOp  $integer2 $integer2 + 2
  StrCpy $tempa $CMDLINE 1 $integer2
  StrCpy $INSTDIR $tempa:\_temp_\cct\localtexmf
  StrCpy $scriptpath "\..\cct-installscript"
  
  MessageBox MB_OK "$(str7)"
  goto endof  
 
installmode:
  StrCpy $mode 0
  StrCpy $INSTDIR $localtexmf
  StrCpy $scriptpath "\cct-installscript"
  MessageBox MB_OKCANCEL "$(str8):$\n    TEXMF ROOT=$texmfroot$\n    LOCALTEXMF=$localtexmf" IDCANCEL cancel IDOK endof
  Goto endof
cancel:
  Abort
endof:
FunctionEnd

Function .onInstSuccess

IntCmp $mode 1 skiptempbat

RMDir /r $texmfroot\makeindex\cct
Delete   $localtexmf\cct\bin\cct*.ini-dist
Delete   $localtexmf\tex\latex\cct\cct.dat
Delete   $localtexmf\tex\latex\cct\cctspace.cfg

; Check install root
call AddCCTtoMikTexRoots
StrCpy $OUTDIR $INSTDIR\cct\bin
Exec '"$INSTDIR\cct\bin\cct-updt.bat" $INSTDIR $texmfroot $localtexmf'

skiptempbat:

FunctionEnd

Function AddCCTtoMikTexRoots
  StrCmp $INSTDIR $localtexmf donotchange
  
  ReadRegStr $miktexroots HKLM "SOFTWARE\MiK\MiKTeX\CurrentVersion\MiKTeX" \
    "Texmf Root Directories"
  
  StrLen $integer1  $miktexroots 
  StrLen $CCTrootLen $INSTDIR
  StrCpy $integer2 0   
  IntCmp $integer1 $CCTrootLen addcctroot addcctroot
  
 loopc:
   StrCpy $tempa $miktexroots $CCTrootLen $integer2
   StrCmp $INSTDIR $tempa donotchange
   IntOp  $integer2 $integer2 + 1
   IntCmp $integer2 $integer1 addcctroot
   Goto loopc

addcctroot:
   WriteRegStr  HKLM "SOFTWARE\MiK\MiKTeX\CurrentVersion\MiKTeX" \
    "Texmf Root Directories" "$miktexroots;$INSTDIR"

donotchange:
FunctionEnd
  
Function un.RemoveCCTKey
  DeleteRegKey HKLM "Software\CCT" 
  ReadRegStr $localtexmf HKLM "SOFTWARE\MiK\MiKTeX\CurrentVersion\MiKTeX" \
    "Local Root"


  StrCmp $CCTroot $localtexmf uncctok
  
  ReadRegStr $miktexroots HKLM "SOFTWARE\MiK\MiKTeX\CurrentVersion\MiKTeX" \
    "Texmf Root Directories"
  
  StrLen $integer1  $miktexroots 
  StrLen $CCTrootLen $CCTroot
  StrCpy $integer2 0   
  
 loopd:
   StrCpy $tempa $miktexroots $CCTrootLen $integer2
   StrCmp $CCTroot $tempa removecctkey
   IntOp  $integer2 $integer2 + 1
   IntCmp $integer2 $integer1 error_uncct
   Goto loopd

removecctkey:
   IntOp  $integer2 $integer2 - 1
   StrCpy $tempa $miktexroots $integer2 0
   IntOp  $integer2 $integer2 + $CCTrootLen
   IntOp  $integer2 $integer2 + 1
   IntOp  $integer1 $integer1 - $integer2
   StrCpy $tempb $miktexroots $integer1 $integer2
   
   WriteRegStr  HKLM "SOFTWARE\MiK\MiKTeX\CurrentVersion\MiKTeX" \
    "Texmf Root Directories" "$tempa$tempb"
   goto uncctok
   
error_uncct:
;just in case
  MessageBox MB_OK "$(str9)"

uncctok:
FunctionEnd

 
