/* $Id: uncct.c,v 1.3 2004/11/26 11:41:33 zlb Exp $ */

typedef unsigned char byte;

#if defined(UNIX) || defined(GO32) || defined(WIN32)
#  define near
#endif

#include <stdio.h>
#include <stdlib.h>
#include <ctype.h>
#include <string.h>

#define BUFFERSIZE		0x2000

static byte buffer[BUFFERSIZE],buffer1[BUFFERSIZE];

static byte *buffer_ptr;
static FILE *f_in = NULL, *f_out = NULL;
static int lineno;

byte near *get_token(register byte *s,int slen)
/* Gets next token. Returns NULL if EOF or error. Uses "buffer" as
   input line buffer when reading from a file. */
{
  register int i;

/* next_line: */
  if (buffer_ptr==NULL) {
    if (f_in==NULL) return(NULL);
    if (fgets(buffer,BUFFERSIZE-1,f_in)==NULL) return(NULL);
    buffer_ptr=buffer;
    lineno++;
  }
  switch (*buffer_ptr) {
    case '\n' :
      buffer_ptr=NULL;
      strcpy(s,"\n");
      break;
    case '\0' :
    case '%' :
/*      buffer_ptr=NULL;
      goto next_line;*/
      strcpy(s,buffer_ptr); buffer_ptr=NULL; break;
    case '\\' :
      strcpy(s,"\\ ");
      if (!*++buffer_ptr) {buffer_ptr=NULL; break;}
      if (!isalpha(*buffer_ptr)) {s[1]=*(buffer_ptr++); break;}
      i=1;
      while (isalpha(*buffer_ptr)) {
        if (i>=slen-2) {
          fprintf(stderr, "Token too long (line %d).%c\n",lineno,7);
          return(NULL);
        }
        s[i++]=*(buffer_ptr++);
      }
      s[i]='\0';
      break;
    default :
      *s=*(buffer_ptr++); s[1]='\0';
      break;
  }
  return(s);
}

void near *get_nonspace_token(register byte *s,int slen)
/* skip next space tokens.
   return the next non-space token (NULL if EOF). */
{
  register byte *p;

  do {
    p=get_token(s,slen);
    if (p==NULL) return(NULL);
    if (*p=='%') continue;
    if (p[0]=='\\' && (p[1]==' ' || p[1]=='\t')) continue;
    if (!p[1]) {
      if (*p==' ' || *p=='\t') continue;
    }
    return(p);
  } while (1);
}

int getcode(void)
/* get next char code. returns -1 if end of group or error */
{
  register byte *p;
  byte s[BUFFERSIZE];

next:
  if ((p=get_nonspace_token(buffer1,BUFFERSIZE))==NULL) return -1;
  if (!strcmp(p,"\\CCA") || !strcmp(p,"\\CCAS") ||
      !strcmp(p,"\\CCB") || !strcmp(p,"\\CCBS") || !strcmp(p,"~")) goto next;
  if (!strcmp(p,"\n")) {fputc('\n', f_out); goto next;}

  if (!strcmp(p,"}")) return -1;
  if (!strcmp(p,"{")) {
    if ((p=get_nonspace_token(buffer1,BUFFERSIZE))==NULL) return -1;
    if (!strcmp(p,"\\char")) {
      strcpy(s,"");
      while (1) {
        if ((p=get_nonspace_token(buffer1,BUFFERSIZE))==NULL) break;
        if (!strcmp(p,"}")) break;
        strcat(s,p);
      }
      if (!strlen(s)) return -1;
      return atoi(s);
    } else return -1;
  }
  return p[0];
}

int main(int argc, char *argv[])
{
  register byte *p;
  register int c1,c2;

  if (argc != 2 && argc != 3) {
    fprintf(stderr,"Usage: uncct inputfile [outputfile] \n");
    return 1;
  }

  buffer_ptr=NULL; lineno=0;
  if ((f_in=fopen(argv[1],"rt"))==NULL) {
    fprintf(stderr,"Can not open file \"%s\".\n",argv[1]);
    return 1;
  }

  if (argc == 3) {
    if ((f_out = fopen(argv[2], "r")) != NULL) {
      /* TODO: ask confirmation to overwrite existing file */
      fclose(f_out);
    }
    if ((f_out = fopen(argv[2], "w+t")) == NULL) {
      fprintf(stderr, "Cannot open outputfile \"%s\".\n", argv[2]);
      return 1;
    }
  }
  else {
    f_out = stdout;
  }

  do {
    if ((p=get_token(buffer1,BUFFERSIZE))==NULL) break;

  next:
    /* Added on 20040922 CJK mode support:
     *	env LANG=C sed -e 's/\\CCTSetChar[ ]*\(.\)[ ]*\(.\)/\1\2/g' */
    if (!strcmp(p,"\\CCTSetChar")) {
	if ((c1 = getcode())==-1 || (c2 = getcode())==-1) break;
	fprintf(f_out, "%c%c", c1, c2);
	continue;
    }
    
    if (!strcmp(p,"\\CCA") || !strcmp(p,"\\CCAS") ||
        !strcmp(p,"\\CCB") || !strcmp(p,"\\CCBS")) {
      /* get next non-space token */
      if ((p=get_nonspace_token(buffer1,BUFFERSIZE))==NULL) break;
    }
    if (!strcmp(p,"{")) {
      if ((p=get_token(buffer1,BUFFERSIZE))==NULL) {fputc('{', f_out); break;}
      if (!strcmp(p,"\\CC")) {
        while (1) {
          if ((c1=getcode())==-1) break;
          if ((c2=getcode())==-1) fprintf(stderr,"\nError on line %d",lineno);
          fprintf(f_out, "%c%c",c1+128,c2+128);
        }
      } else {fputc('{', f_out); goto next;}
    } else fprintf(f_out, "%s",p);
  } while (1);

  fclose(f_in);
  if (f_out != stdout) fclose(f_out); else fflush(f_out);

  return 0;
}
