/* $Id: string-utils.c,v 1.2 2004/11/26 11:41:33 zlb Exp $ */

#ifdef UNIX

#include <ctype.h>

char *
strlwr(char *s)
{
  char *p;
  for (p=s; *p; p++) *p=tolower(*p);
  return s;
}

int
stricmp(const char *s0, const char *s1)
{
  int i;
  while (*s0 != '\0' && *s1 != '\0') {
    i = toupper(*(s0++)) - toupper(*(s1++));
    if (i) return i;
  }
  return toupper(*s0) - toupper(*s1);
}

int
strnicmp(const char *s0, const char *s1, int n)
{
  int i;
  while (n-- > 0 && *s0 != '\0' && *s1 != '\0') {
    i = toupper(*(s0++)) - toupper(*(s1++));
    if (i) return i;
  }
  return n > 0 ? toupper(*s0) - toupper(*s1) : 0;
}
#endif
