/* $Id: roman-number.c,v 1.2 2004/11/26 11:41:33 zlb Exp $ */

#include <stdio.h>
#include <string.h>
#include <ctype.h>

int
roman_number(const char *r)
/* returns the number (plus 10000 if lowercase) in roman presentation
 * returns 0 if error */
{
    static char letters[] = "IVXLCDM";
    static unsigned short values[] = {1, 5, 10, 50, 100, 500, 1000};
    int n = strlen(r);
    char indices[n + 1], *p;
    int i, j, k;
    int value = 0, v;
    int is_lower = (*r >= 'a' && *r <= 'z');
    
    for (i = 0; i < n; i++) {
	if ((p = strchr(letters, is_lower? toupper(*(r++)) : *(r++))) == NULL)
	    return 0;
	indices[i] = j = p - letters;
    }
    indices[n] = -1;

    k = indices[0];
    for (i = 0; i < n; i++) {
	v = values[j = k];
	k = indices[i+1];
	if (j < k) {
	    if ((k == j + 1 && !(j&1)) || k == j + 2)
		v = -v;
	    else
		return 0;
	}
	value += v; 
    }

    return value + (is_lower ? 10000 : 0);
}

#ifdef TEST
int main(int argc, char *argv[])
/* Test roman number conversion */
{
    if (argc != 2) {
	fprintf(stderr, "Usage: %s roman-number\n", argv[0]);
	return 1;
    }

    printf("%d\n", roman_number(argv[1]));
    return 0;
}
#endif
