/* $Id: patchdvi.h,v 1.2 2004/11/26 11:41:33 zlb Exp $ */

#define NbrOfZiTi  26		/* nbr. of Chinese ZiTi's */
#define NbrOfGroup (2*NbrOfZiTi+2)
#define HanZi0     1410		/* no. of the first hanzi of category 1  */
#define HanZi1     5170		/* no. of the first hanzi of category 2 */
#define HanZi2     8178		/* no. of the last hanzi of category 2 + 1 */

#define GetGroup(ziti,charno)	\
	(charno<hanzi0) ? 1 : ( (charno<hanzi1) ? 2*ziti:2*ziti+1 )

#define MAXCCNO		(HanZi2-1)
#define BUFFERSIZE	((unsigned)0xfff0)
#define RCTLEN  4096  /* initial maxi. length of run counts */

#define dvi_set_char_0    0
#define dvi_set_char_127  127

#define dvi_set1          128
#define dvi_set4          131

#define dvi_put1          133
#define dvi_put4 	  136

#define dvi_bop           139

#define dvi_push          141
#define dvi_pop           142
#define dvi_right4        146
#define dvi_down4         160

#define dvi_fnt_num_0     171
#define dvi_fnt_num_63    234

#define dvi_fnt1          235
#define dvi_fnt4          238

#define dvi_xxx1          239
#define dvi_xxx4          242

#define dvi_fnt_def1      243
#define dvi_fnt_def4      246

#define dvi_pre           247
#define dvi_post          248
#define dvi_post_post     249

#define dvi_undef	  250

#define pk_pre   247
#define pk_post  245
#define pk_no_op 246

static byte CommLen[dvi_post_post-dvi_set1+1] = {
/* The following table contains the lengths en byte of
   the parameter of DVI commands between "set1" and "post_post" */
/* set1 */	1,  2,  3,  4,  8,  1,  2,  3,  4,  8,  0, 44,  0,  0,  0,
/* right1 */	1,  2,  3,  4,  0,  1,  2,  3,  4,  0,  1,  2,  3,  4,
/* down1 */	1,  2,  3,  4,  0,  1,  2,  3,  4,  0,  1,  2,  3,  4,
/* fnt_num_0 */	0,  0,  0,  0,  0,  0,  0,  0,
		0,  0,  0,  0,  0,  0,  0,  0,
		0,  0,  0,  0,  0,  0,  0,  0,
		0,  0,  0,  0,  0,  0,  0,  0,
		0,  0,  0,  0,  0,  0,  0,  0,
		0,  0,  0,  0,  0,  0,  0,  0,
		0,  0,  0,  0,  0,  0,  0,  0,
		0,  0,  0,  0,  0,  0,  0,  0,
/* fnt1 */      1,  2,  3,  4,  0,  0,  0,  0,  0,  0,  0,  0,
/* pre */	0,  28, 5};

typedef struct {
  int fontno;		/* fontno */
  int is_cc;		/* is Chinese ? */
  unsigned long cksum;	/* check sum */
  unsigned long ssize;	/* scale size */
  void *chain;		/* pointer to next element */
} fontdescr;

typedef struct {
  int fontno;		/* fontno */
  byte group;		/* group */
  int nchars;		/* number of characters */
  byte far *charset;	/* character set, each bit represents a CC */
  void *chain;		/* chain to next element */
} ccfontdescr;

typedef struct {
  int fontno;
  int charno;
  byte group;
} ccdescr;

