/* $Id: gb2wncyr.c,v 1.2 2004/11/26 11:41:33 zlb Exp $ */

/* This program maps cyrillic characters in QU 07 to characters in the
   wncy* series fonts. You need to define the font switching command
   \wncyr. For example:

   	\font\wncyr=wncyr10 at 10pt
*/

#include <stdio.h>
#include <string.h>
#include <ctype.h>

#include "gb2wncyr.h"

typedef unsigned char byte;

static byte *TeX_char(int code)
{
    static byte buffer[10];

    if (code>=32 && code!='_' && code!='~' && code!='^' && code!=0x7f) {
	buffer[0]=code;
	buffer[1]='\0';
    } else {
	sprintf(buffer, "{\\char%d}", code);
    }
    return buffer;
}

int main(int argc, char *argv[])
{
    FILE *f_in;
    int mode, ch, ch1;

    if (argc!=2) {
	fprintf(stderr, "This program maps GB2312 cyrillic characters to one of the \"wncy*\" fonts.\n");
	fprintf(stderr, "\nUsage:  gb2wncyr inputfile [>outputfile]\n\n");
	fprintf(stderr, "Note: the user should define \"\\wncyr\" which switches the encoding, e.g.:\n\n");
	fprintf(stderr, "    \\font\\wncyr=wncyr10\n");
	return 1;
    }

    if ((f_in=fopen(argv[1], "rt"))==NULL) {
	fprintf(stderr, "Error: cannot open \"%s\" for input\n", argv[1]);
	return 3;
    }

    mode=0;

    while (1)  {
	ch=fgetc(f_in);
	if (ch==EOF) break;
	if (ch<128) {
	    if (!isspace(ch) && mode) {
		mode=0;
		printf("}");
	    }
	    putchar(ch);
	    continue;
	}
	ch1=fgetc(f_in);
	if (ch!=160+7 || ch1<161 || ch1>254) {
	    if (mode) {
		mode=0;
		printf("}");
	    }
	    printf("%c%c", ch, ch1);
	    continue;
	}
	if (!mode) {
	    mode=1;
	    printf("{\\wncyr ");
	}
	printf("%s", TeX_char(chartable[ch1-161].code));
    }
    if (mode) printf("}");

    fclose(f_in);

    return 0;
}
