/* $Id: fullpath.c,v 1.2 2004/11/26 11:41:32 zlb Exp $ */

/*#undef ABSOLUTE_PATH*/

#include <stdio.h>
#include <string.h>
#include <stdlib.h>
#if defined(WIN32) && !defined(__MINGW32__)
#  define PATH_MAX      _MAX_PATH+1
#else
#  include <limits.h>	/* PATH_MAX */
#  include <unistd.h>	/* getcwd */
#endif
#ifdef ABSOLUTE_PATH
#  include <sys/param.h>
#endif

char *fullpath(const char *cmd)
/* Try to locate the full pathname of 'cmd', using the PATH variable */
{
  char *path, *p;
  char s[PATH_MAX];
  static char fpath[PATH_MAX];
  int n, found = 0;
  FILE *f;

#ifdef UNIX
  if (strchr(cmd, '/')==NULL) {
#else
  if (strchr(cmd, '/') == NULL && strchr(cmd, '\\') == NULL 
		  && strchr(cmd, ':') == NULL) {
    /* DOS/Windows: always check dir first */
    p = getcwd(fpath, sizeof(fpath));
    if (p != NULL && (n = strlen(p) - 1) >= 0) {
      strcpy(s, p);
      if (s[n] != '/' && s[n] != '\\') strcat(s, "\\");
      strcat(s, cmd);
#ifdef TEST
      fprintf(stderr, "Looking in (current) directory %s:\n", p);
#endif
      /* TODO: check for .com, .bat, etc? */
      /*if (strrchr(cmd, '.') == NULL) strcat(s, ".exe");*/
      if ((n=strlen(cmd))<4 || stricmp(cmd+n-4,".exe")) strcat(s, ".exe");
      if ((f=fopen(s, "r")) != NULL) {
	fclose(f);
	found = 1;
      }
    }
#endif
    path=getenv("PATH");
    while (!found && path != NULL && *path != '\0') {
#ifdef UNIX
      p=strchr(path, ':');
#else
      p=strchr(path, ';');
#endif
      if (p==NULL) p=path+strlen(path);
      n=p-path;
      if (n>0) {
        strncpy(s, path, n);
        s[n]='\0';
#ifdef TEST
	fprintf(stderr, "Looking in directory %s:\n", s);
#endif
#ifdef UNIX
        if (s[n-1]!='/') strcat(s, "/");
#else
        if (s[n-1] != '/' && s[n-1] != '\\' && s[n-1] != ':') strcat(s, "\\");
#endif
        strcat(s, cmd);
#ifndef UNIX
	/* TODO: also check for .com, .bat, etc? */
        /*if (strrchr(cmd, '.') == NULL) strcat(s, ".exe");*/
	if ((n=strlen(cmd))<4 || stricmp(cmd+n-4,".exe")) strcat(s,".exe");
#endif
        if ((f=fopen(s, "r")) != NULL) {
          fclose(f);
	  found = 1;
          break;
        }
      }
      if (*p!='\0') p++;
      path=p;
    }
  }

  if (!found) {
#ifdef TEST
    fprintf(stderr, "\nCommand not found!\n", s);
#endif
    strcpy(s, cmd);
  }

#ifdef ABSOLUTE_PATH
  realpath(s, fpath);
#else
  strcpy(fpath, s);
#endif

  return fpath;
}

#ifdef TEST
int main()
{
    char s[1024];

    fprintf(stderr, "Enter progname: ");
    scanf("%s", s);
    fprintf(stderr, "Fullpath of the executable = \"%s\".\n", fullpath(s));
}
#endif
