/* $Id: cctinit.c,v 1.2 2004/11/26 11:41:32 zlb Exp $
 *
 * Initialization program for CCT */

#define GBK

#if defined(WIN32) && defined(_DEBUG)
#	define DEBUG
#endif

#include <stdio.h>
#include <stdlib.h>
#include <ctype.h>
#include <string.h>
#if !defined(UNIX) && !defined(GO32) && !defined(WIN32)
#  include <dir.h>
#  include <process.h>
#  include <alloc.h>
#else
/*#  define long int*/
#  ifdef GO32
#    include <sys/stat.h>
#    include <sys/types.h>
#  endif
#  ifdef WIN32
#    include <malloc.h>
#    include <direct.h>
#  endif
#endif

#if defined(WIN32) && !defined(__MINGW32__)
#  define PATH_MAX      _MAX_PATH+1
#else
#  include <limits.h>   /* PATH_MAX */
#endif

#include "proto.h"
#include "fullpath.h"

typedef unsigned char byte;
typedef enum {SongTi,HeiTi,KaiShu,FangSong,BiaoSong} ZiTi;

#define firstziti	SongTi
#define lastziti	BiaoSong
#define defaultziti	SongTi
#define defaultsize	5

byte *zititable[lastziti+1]={"songti","heiti","kaishu","fangsong","biaosong"};
byte *fontname="ccfnt";

#define TRUE		1
#define FALSE		0

#define version		5.17

/* set ExASCII to TRUE for setting Chinese chars in the range 128-255 */
#define ExASCII		FALSE

byte tfmpath[PATH_MAX], cctpath[PATH_MAX], stypath[PATH_MAX];

FILE *f_data=NULL,*f_sty=NULL,*f_ini=NULL;
FILE *f_tfm=NULL;

#if defined(UNIX) || defined(GO32) || defined(__MINGW32__)
  static void fcloseall _VOID
  {
    if (f_data!=NULL) {fclose(f_data); f_data=NULL;}
    if (f_sty!=NULL) {fclose(f_sty); f_sty=NULL;}
    if (f_ini!=NULL) {fclose(f_ini); f_ini=NULL;}
    if (f_tfm!=NULL) {fclose(f_tfm); f_tfm=NULL;}
  }
#endif

void ErrExit _P1(byte *,s)
{
  fprintf(stderr,"%s\n",s);
  fcloseall();
  exit(1);
}

void adjust_path _P1(byte *,path)
{
  register int c,n;

  n=strlen(path);
  if (n) {
    c=path[n-1];
#ifndef UNIX
    if (c!=':' && c!='\\' && c!='/') strcat(path,"\\");
#else
    if (c!='/') strcat(path,"/");
#endif
  }
}

int search _P3(int,n, int *,a, int,no)
/* Returns i, 0<=i<n, such that a[i]=no. Returns -1 if not found */
{
   register int i;

   for (i=0;i<n;i++) if (a[i]==no) return(i);
   return(-1);
}

#define TwoPower20		1048576.0
#define realtofix(r)		\
  ((r)>0 ? (long)((r)*TwoPower20+0.5):-(long)((-r)*TwoPower20+0.5))

#define LSB	0
#define MSB	1
static int byte_order;

void *int_to_bytes _P2(void *,p, int,size)
/* returns the pointer to the buffer containing the results */
{
  register byte *p0, *p1;
  static byte buffer[4];

  if (byte_order==MSB) {		/* MSB first */
    memcpy(buffer, ((byte *)p)+sizeof(long)-size, size);
  } else {				/* LSB first */
    p0=buffer, p1=((byte *)p)+size-1;
    while (size--) *(p0++)=*(p1--);
  }
  return(buffer);
}

#define putint(n, f_tfm) {			\
  int iiiii=n;					\
  fwrite(int_to_bytes(&iiiii,2),2,1,f_tfm);	\
}

#define putlong(n,f_tfm) {			\
  long lllll=n;					\
  fwrite(int_to_bytes(&lllll,4),4,1,f_tfm);	\
}

void tfmout _P8(double,ds, double,width, double,height,
                double,h_space_factor, double,v_space_factor,
                int,bc, int,ec, byte *,tfmname)
{
   static long char_info_word=0x01110000l;
   static int len[12] = {
            0,		/* lf, to be calculated */
            2,		/* lh */
            0,		/* bc */
            127,	/* ec */
            2,		/* nw */
            2,		/* nh */
            2,		/* nd */
            1,		/* ni */
            0,		/* nl */
            0,		/* nk */
            0,		/* ne */
            7};		/* np */
  double cs,depth,slant,space,stretch,shrink,x_height,quad,extra_space;
  double param[7];  /* in pt */
  int lf;
  register int i;

  cs=height;
  depth=height*v_space_factor;
  slant=0.0;
  space=width*h_space_factor;
  stretch=space*0.5;
  shrink=space*0.33333333333;
  x_height=height;
  quad=width+space;
  extra_space=0.0;

  param[0]=slant;
  param[1]=space;
  param[2]=stretch;
  param[3]=shrink;
  param[4]=x_height;
  param[5]=quad;
  param[6]=extra_space;

  len[2]=bc; len[3]=ec;

  if ((f_tfm=fopen(tfmname,"w+b"))==NULL) {
    byte s[PATH_MAX+40];
    sprintf(s,"Cannot create output file \"%s\"!",tfmname);
    ErrExit(s);
  }

  lf=6+len[1]+(len[3]-len[2]+1);
  for (i=4;i<12;i++) lf+=len[i]; len[0]=lf;
  for (i=0;i<12;i++) putint(len[i],f_tfm);

  /* Header data */
  putlong(realtofix(cs),f_tfm);    /* chk-sum=height */
  putlong(realtofix(ds),f_tfm);

  /* char_info table */
  for (i=len[2];i<=len[3];i++) putlong(char_info_word,f_tfm);

  /* width table */
  putlong(0l,f_tfm); putlong(realtofix(width/ds*0.5),f_tfm);

  /* height table */
  putlong(0l,f_tfm); putlong(realtofix(height/ds),f_tfm);

  /* depth table */
  putlong(0l,f_tfm); putlong(realtofix(depth/ds),f_tfm);

  /* italic correction table */
  putlong(0l,f_tfm);

  /* lig./kern table */
  /* kern table */
  /* extensible char. words */

  /* parameters */
  putlong(realtofix(param[0]),f_tfm);
  for (i=1;i<7;i++) putlong(realtofix(param[i]/ds),f_tfm);
  fclose(f_tfm); f_tfm=NULL;
}

#define BUFFLEN 0x2000

int main _P2(int,argc, char **,argv)
{
  int maxisize;
  int n,m,gap,i,j1,j2;
  double a,*width,*height,*hs,*vs;
  int *zihao;
  byte ch,s[PATH_MAX],*work,*op_line,s_ini[PATH_MAX];
  int dummyflag;

  /* determines the byte order */
  {
    long ll=0x4321;
    if (*((byte *)&ll)==0x21) byte_order=LSB; else byte_order=MSB;
  }

  if ((work=malloc(BUFFLEN))==NULL) ErrExit("Memory allocation error!");

#ifndef GBK
  fprintf(stderr,"CCT - Initialization program, v%0.2f\n",(float)version);
#else
  fprintf(stderr,"CCT - Initialization program, v%0.2f (supporting GBK)\n",(float)version);
#endif

  /* Setup default paths. 'cctpath' is where to find cct.dat */
#ifndef UNIX
  strcpy(cctpath,fullpath(argv[0]));
  i=strlen(cctpath)-1;
  while (cctpath[i]!='/' && cctpath[i]!='\\' && cctpath[i]!=':' && i>=0) i--;
  if (i>0 && (cctpath[i]=='\\' || cctpath[i]=='/')) i--;
  cctpath[i+1]='\0';
  adjust_path(cctpath);
#if 0
  strcpy(tfmpath,cctpath); strcat(tfmpath,"FONTTFMS");
  strcpy(stypath,cctpath); strcat(stypath,"INPUTS");
#else
  strcpy(tfmpath,cctpath);
  strcpy(stypath,cctpath);
#endif
  /* processing evironment vars */
  if ((op_line=getenv("TEXINPUTS"))!=NULL) strcpy(stypath, op_line);
  if ((op_line=getenv("FONTTFMS"))!=NULL)  strcpy(tfmpath, op_line);
#else
  strcpy(tfmpath,"/usr/local/lib/texmf/fonts/cct/tfm");
  strcpy(stypath,"/usr/local/lib/texmf/tex/cct");
#if 0
  /* processing evironment vars */
  if ((p=getenv("TEXINPUTS"))!=NULL) {
    i=0;
    while (*p!='\0' && *p!=':') stypath[i++]=*(p++);
    stypath[i]=0;
  }
  if ((p=getenv("FONTTFMS"))!=NULL) {
    i=0;
    while (*p!='\0' && *p!=':') tfmpath[i++]=*(p++);
    tfmpath[i]=0;
  }
#endif
#endif

#ifdef DEBUG
  fprintf(stderr, "Before cctinit.ini:\n");
  fprintf(stderr, "\tcctpath=%s\n", cctpath);
  fprintf(stderr, "\ttfmpath=%s\n", tfmpath);
  fprintf(stderr, "\tstypath=%s\n", stypath);
#endif

  dummyflag=TRUE;

  /* process command line arguments */
  /* get initialization file name */
  strcpy(s_ini, fullpath(argv[0]));
#ifndef UNIX
  i = strlen(s_ini) - 1;
  while (i > 0 && s_ini[i] != '.' && s_ini[i] != '\\'
	        && s_ini[i] != '/' && s_ini[i] != ':') i--;
  ((s_ini[i] == '.') ? strcpy : strcat)(s_ini + i, ".ini");
#else
  strcat(s_ini,".ini");
#endif
  f_ini=fopen(s_ini,"rt");
  if (f_ini!=NULL) fprintf(stderr, "Processing options in \"%s\"...\n", s_ini);
  op_line=NULL;
  for (i=1;i<argc || f_ini!=NULL;) {
    byte *p;

    if (f_ini!=NULL) {
      if (op_line==NULL) {
        if ((op_line=fgets(work,BUFFLEN,f_ini))==NULL) {
          fclose(f_ini); f_ini=NULL;
          continue;
        }
        /* check if line begins with '%' */
        if (op_line[0]=='%') {	/* comment line */
          op_line=NULL;
          continue;
        }
      }
      /* get next string from op_line */
      while (isspace(*op_line)) op_line++;
      if (!*op_line) {
        op_line=NULL;
        continue;
      }
      p=s;
      while (!isspace(*op_line) && *op_line && p-s<BUFFLEN-1)
        *(p++)=*(op_line++); *p='\0';
    } else {
      strcpy(s,argv[i]);
      i++;
    }
    p=s;
    if (*p!='-' || strlen(p)<=1) {
opt_err:
      sprintf(work,"Invalid option \"%s\" ",s);
      if (f_ini!=NULL) {
        fclose(f_ini); f_ini=NULL;
        sprintf(s,"in the initialization file\n\"%s\".",s_ini);
        strcat(work,s);
      } else strcat(work,"in the command line.");
      fprintf(stderr,"%s\n",work);
      fprintf(stderr,"Valid options are:\n");
      fprintf(stderr,"\t-X:  Use TeX's \\special command to control ZiTi\n");
      fprintf(stderr,"\t-T:  Directory for TeX TFM fils\n");
      fprintf(stderr,"\t-H:  Directory for TeX input fils\n");
      fcloseall();
      exit(1);
    }
    ch=toupper(p[1]);
    switch (ch) {
      case 'X' : dummyflag=FALSE; break;
      case 'T' : strcpy(tfmpath,p+2); break;
      case 'H' : strcpy(stypath,p+2); break;
      default  : goto opt_err;
    }
  }

#ifdef DEBUG
  fprintf(stderr, "After cctinit.ini:\n");
  fprintf(stderr, "\tcctpath=%s\n", cctpath);
  fprintf(stderr, "\ttfmpath=%s\n", tfmpath);
  fprintf(stderr, "\tstypath=%s\n", stypath);
#endif

  /* Make directories */
#ifndef UNIX
#  ifdef GO32
     mkdir(cctpath, 0755);
     mkdir(tfmpath, 0755);
     mkdir(stypath, 0755);
#  else
     mkdir(cctpath);
     mkdir(tfmpath);
     mkdir(stypath);
#  endif
#else
  strcpy(cctpath,stypath);
#endif

  adjust_path(cctpath);
  adjust_path(tfmpath);
  adjust_path(stypath);

  /* Reading data */
  strcat(cctpath,"cct.dat");
  fprintf(stderr, "Reading file \"%s\"...\n", cctpath);
  if ((f_data=fopen(cctpath,"rt"))==NULL) {
err1:
    sprintf(s,"Cannot read file \"%s\"!",cctpath);
    if (f_data!=NULL) {fclose(f_data); f_data=NULL;}
    ErrExit(s);
  }

  if (!fscanf(f_data,"%d",&maxisize)) goto err1;
  if (maxisize<=0 || maxisize>26) ErrExit("Invalid number of zihaos!");

  width=malloc(maxisize*sizeof(double));
  height=malloc(maxisize*sizeof(double));
  hs=malloc(maxisize*sizeof(double));
  vs=malloc(maxisize*sizeof(double));
  zihao=malloc(maxisize*sizeof(int));
  if (zihao==NULL || width==NULL || height==NULL || hs==NULL || vs==NULL)
    ErrExit("Memory overflow.");

  for (i=0;i<maxisize;i++) {
    fscanf(f_data,"%lf %lf %lf %lf %d",width+i,height+i,hs+i,vs+i,zihao+i);
  }
  fclose(f_data); f_data=NULL;

  /* Sorting data */
  n=maxisize; gap=n>>1;
  while (gap>0) {
    for (i=gap;i<n;i++) {
      j1=i; j2=i-gap;
      while (j2>=0 && width[j2]<width[j1]) {
	a=width[j2]; width[j2]=width[j1]; width[j1]=a;
        a=height[j2]; height[j2]=height[j1]; height[j1]=a;
        a=hs[j2]; hs[j2]=hs[j1]; hs[j1]=a;
        a=vs[j2]; vs[j2]=vs[j1]; vs[j1]=a;
        m=zihao[j2]; zihao[j2]=zihao[j1]; zihao[j1]=m;
        j1=j2;
        j2=j2-gap;
      }
    }
    gap>>=1;
  }

  /* Generates "*.tfm" files */
  for (i=0;i<maxisize;i++) {
    sprintf(s,"%s%s%c%s",tfmpath,fontname,'a'+i,".tfm");
    fprintf(stderr,"Creating file \"%s\"...",s);
#ifndef GBK
#   if ExASCII
      tfmout(width[i],width[i],height[i],hs[i],vs[i],161,255,s);
#   else
      tfmout(width[i],width[i],height[i],hs[i],vs[i],33,127,s);
#   endif
#else
      tfmout(width[i],width[i],height[i],hs[i],vs[i],0,255,s);
#endif
    fprintf(stderr,"%c%c%c   \n",8,8,8);
  }

  /* Generates "ccdummy.tfm" */
  if (dummyflag) {
    strcpy(s,tfmpath); strcat(s,"ccdummy.tfm");
    fprintf(stderr,"\nCreating file \"%s\"...",s);
    tfmout(10.0,0.0,0.0,0.0,0.0,33,127,s);
    fprintf(stderr,"%c%c%c   \n",8,8,8);
  }

  /* Generates "cchead.sty" */
  strcat(stypath,"cchead.sty");
  fprintf(stderr,"\nCreating file \"%s\"...",stypath);
  if ((f_sty=fopen(stypath,"w+t"))==NULL) {
    sprintf(s,"Cannot create file \"%s\"!",stypath);
    ErrExit(s);
  }

  fprintf(f_sty,"\\edef\\ccheadCatAt{\\the\\catcode`\\@}\n");
  fprintf(f_sty,"\\edef\\ccheadCatEx{\\the\\catcode`\\!}\n");
  fprintf(f_sty,"\\catcode`\\@=11\n");
  fprintf(f_sty,"\\catcode`\\!=11\n");
#if ExASCII
    for (i=129;i<256;i++) fprintf(f_sty,"\\catcode%d=11\n",i);
    fprintf(f_sty,"%%\n");
#endif

  fprintf(f_sty,"%%\n\\ifx\\DeclareRobustCommand\\undefined\n");
  fprintf(f_sty,"  \\let\\!def\\def\n");
  fprintf(f_sty,"\\else\n");
  fprintf(f_sty,"  \\let\\!def\\DeclareRobustCommand\n");
  fprintf(f_sty,"\\fi\n");
  fprintf(f_sty,"%%\n");

  /*-------- Process font informations --------*/
  for (i=0;i<maxisize;i++) {
    fprintf(f_sty,"\\let\\%s%c=\\relax\n",fontname,i+'a');
  }
  fprintf(f_sty,"%%\n");
  fprintf(f_sty,"\\newcount\\!ZihaoNo\t%% contains current zihao no.\n");
  fprintf(f_sty,"\\newdimen\\ccwd\t\t%% contains width+space of a CC\n");
  fprintf(f_sty,"\\newdimen\\ccht\t\t%% contains height of a CC\n");
  fprintf(f_sty,"\\newdimen\\ccdp\t\t%% contains depth of a CC\n");
  fprintf(f_sty,"\\newbox\\!ccbox\t\t%% used to get width,depth & height\n");
  fprintf(f_sty,"\\newskip\\!ccbdskip\t%% used to adjust spacing of some BiaoDians\n");
  fprintf(f_sty,"%%\n");
  fprintf(f_sty,"\\!def\\CCA{\\hskip\\!ccbdskip }\t%% Add glue after some biadians\n");
  fprintf(f_sty,"\\!def\\CCAS{\\!ccbdskips }\t%% Add glue after some biadians\n");
  fprintf(f_sty,"\\!def\\CCB{\\hskip\\!ccbdskip }\t%% Add glue before some biadians\n");
  fprintf(f_sty,"\\!def\\CCBS{\\!ccbdskips }\t%% Add glue before some biadians\n");
  fprintf(f_sty,"\\def\\!CurrentZiJu{%0.4f}\n",(float)hs[0]);
  fprintf(f_sty,"\\def\\!SetCCFont#1#2{\\ifx#1\\relax\\font#1=#2 \\hyphenchar#1 -1 \\fi\\let\\DaXiao#1}\n");
  fprintf(f_sty,"\\def\\!SetupDaXiao#1{\\!ZihaoNo=#1\n");
  for (i=0;i<maxisize;i++) {
    fprintf(f_sty,"  \\ifnum\\!ZihaoNo=%d\\!SetCCFont{\\%s%c}{%s%c}\\else\n",
                  zihao[i],fontname,i+'a',fontname,i+'a');
  }
  fprintf(f_sty,"  \\errmessage{Invalid \\string\\zihao\\space command ignored}");
  for (i=0;i<maxisize;i++) fprintf(f_sty,"\\fi");
  fprintf(f_sty,"\n}\n");

  fprintf(f_sty,"\\def\\!SetZiJu{\\setbox\\!ccbox\\hbox{\\DaXiao M}\\relax\t%% setup temp box\n");
  fprintf(f_sty,"  \\ccwd=2\\wd\\!ccbox \\ccht=\\ht\\!ccbox \\ccdp=\\dp\\!ccbox\t%% get width,height,depth\n");
  fprintf(f_sty,"  \\fontdimen2\\DaXiao=\\!CurrentZiJu\\ccwd\t%% space\n");
  fprintf(f_sty,"  \\fontdimen3\\DaXiao=0.5\\fontdimen2\\DaXiao\t%% stretch\n");
  fprintf(f_sty,"  \\fontdimen4\\DaXiao=0.3333333333\\fontdimen2\\DaXiao\t%% shrink\n");
  fprintf(f_sty,"  \\fontdimen6\\DaXiao=\\ccwd\t%% quad\n");
  fprintf(f_sty,"  \\advance\\ccwd by\\fontdimen2\\DaXiao\t%% adjust \\ccwd\n");
  fprintf(f_sty,"  \\!ccbdskip=0pt plus 0pt minus 0.5\\ccwd\t%%\n");
  fprintf(f_sty,"  \\def\\!ccbdskips{\\leavevmode\\vrule width -0.45\\ccwd height0pt depth0pt}\\relax\n");
  fprintf(f_sty,"}\n");
  fprintf(f_sty,"%%\n");
  fprintf(f_sty,"\\def\\!ziti#1{\\def\\!ZiTi{#1}\\relax}\n");
  fprintf(f_sty,"\\!def\\ziti{\\!ziti}\n");
  fprintf(f_sty,"%%\n");
  fprintf(f_sty,"\\def\\!zihao#1{\\!SetupDaXiao{#1}\\!SetZiJu\\relax}\n");
  fprintf(f_sty,"\\!def\\zihao{\\!zihao}\n");
  fprintf(f_sty,"%%\n");
  fprintf(f_sty,"\\def\\!ziju#1{\\def\\!CurrentZiJu{#1}\\!SetZiJu\\relax}\n");
  fprintf(f_sty,"\\!def\\ziju{\\!ziju}\n");
  fprintf(f_sty,"%%\n");
  for (i=firstziti;i<=lastziti;i++) {
    fprintf(f_sty,"\\!def\\%s{\\ziti{%c}\\relax}\n",zititable[i],'A'+i);
  }
  if (!dummyflag) {
    fprintf(f_sty,"\\!def\\YH{\\ziti{@}\\CC }\n");
  } else {
    fprintf(f_sty,"\\!def\\YH{\\ziti{\\char64}\\CC }\n");
  }
  if (!dummyflag) {
    fprintf(f_sty,"\\!def\\pushziti{\\special{ZiTi=?}\\relax}\n");
    fprintf(f_sty,"\\!def\\popziti{\\special{ZiTi=>}\\relax}\n");
  } else {
    fprintf(f_sty,"\\!def\\pushziti{{\\ccdummy\\char63}\\relax}\n");
    fprintf(f_sty,"\\!def\\popziti{{\\ccdummy\\char62}\\relax}\n");
  }
  fprintf(f_sty,"%%\n");
  if (!dummyflag)
    fprintf(f_sty,"\\!def\\CC{\\!SetZiJu\\catcode`\\~=\\active\\def~{\\penalty\\@M \\ }\\special{ZiTi=\\!ZiTi}\\DaXiao\\frenchspacing }\n");
  else {
    fprintf(f_sty,"\\font\\ccdummy=ccdummy at 10 true pt\n");
    fprintf(f_sty,"\\hyphenchar\\ccdummy -1 %%\n");
    fprintf(f_sty,"\\!def\\CC{\\!SetZiJu\\catcode`\\~=\\active\\def~{\\penalty\\@M \\ }\\ccdummy\\!ZiTi\\DaXiao}\n");
  }
  fprintf(f_sty,"%%\n");
  i=search(maxisize,zihao,defaultsize);
  if (i<0) i=0;
  fprintf(f_sty,"\\%s\\zihao{%d}\n",zititable[defaultziti],zihao[i]);
  fprintf(f_sty,"\\catcode`\\@=\\ccheadCatAt\n");
  fprintf(f_sty,"\\catcode`\\!=\\ccheadCatEx\n");
  fprintf(f_sty,"\\endinput\n");

  fclose(f_sty); f_sty=NULL;
  fprintf(stderr,"%c%c%c   \n\nDone.\n",8,8,8);

  return 0;
}
