/* $Id: bmf2pcx.h,v 1.2 2004/11/26 11:41:32 zlb Exp $ */

/* The PCX file header */

#define PCXVERSION 3	/* 3 or 5 */

static byte PCXHeader[]={
    10,		/* PCX header tag */
    PCXVERSION,	/* version no. 5=3.0+palette, 3=2.8/3.0 without palette */
    1,		/* encoding mode (!=0 ==> RLL compression) */
    1,		/* bits per pixel */
    0,0,	/* picture dimensions: X1 (inclusive) */
    0,0,	/* picture dimensions: Y1 (inclusive) */
    186,3,	/* picture dimensions: X2 (inclusive) */
    225,1,	/* picture dimensions: Y2 (inclusive) */
    44,1,	/* Hres (dpi) */
    44,1,	/* Vres (dpi) */
    /* Color palette */
    0,0,0,	/* color 0 */
    0,0,0,	/* color 1 */
    0,0,0,	/* color 2 */
    0,0,0,	/* color 3 */
    0,0,0,	/* color 4 */
    0,0,0,	/* color 5 */
    0,0,0,	/* color 6 */
    0,0,0,	/* color 7 */
    0,0,0,	/* color 8 */
    0,0,0,	/* color 9 */
    0,0,0,	/* color 10 */
    0,0,0,	/* color 11 */
    0,0,0,	/* color 12 */
    0,0,0,	/* color 13 */
    0,0,0,	/* color 14 */
    0,0,0,	/* color 15 */
    /* Info field */
    0,		/* Vmode (ignored) */
    1,		/* Number of planes */
    120,0,	/* bytes per line */
    /* next 60 bytes are unused (for filing out header to 128 bytes) */
    0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
    0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
    0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0
};

#ifdef UNIX
#  define AddFileExtension(outname) strcat(outname,".pcx")
#else
#  define AddFileExtension(outname) strcat(strlwr(outname),".pcx")
#endif

#define WriteFileHeader(width,height,dpix,dpiy,f_out) { 	\
  *((byte *)(PCXHeader+ 8))=(width-1)%256;			\
  *((byte *)(PCXHeader+ 9))=(width-1)/256;			\
  *((byte *)(PCXHeader+10))=(height-1)%256;			\
  *((byte *)(PCXHeader+11))=(height-1)/256;			\
  *((byte *)(PCXHeader+12))=((int)((dpix+32768l)/65536l))%256;	\
  *((byte *)(PCXHeader+13))=((int)((dpix+32768l)/65536l))/256;	\
  *((byte *)(PCXHeader+14))=((int)((dpiy+32768l)/65536l))%256;	\
  *((byte *)(PCXHeader+15))=((int)((dpiy+32768l)/65536l))/256;	\
  *((byte *)(PCXHeader+66))=widthb%256;				\
  *((byte *)(PCXHeader+67))=widthb/256;				\
  if (PCXVERSION==5) {						\
    *((byte *)(PCXHeader+16))=255;				\
    *((byte *)(PCXHeader+17))=255;				\
    *((byte *)(PCXHeader+18))=255;				\
    *((byte *)(PCXHeader+16+15*3+0))=0;				\
    *((byte *)(PCXHeader+16+15*3+1))=0;				\
    *((byte *)(PCXHeader+16+15*3+2))=0;				\
  } else {							\
    neg_flag=!neg_flag;						\
  }								\
  fwrite(PCXHeader,sizeof(PCXHeader),1,f_out);			\
}

void WriteScanLine _P3(byte *, ScanLine, unsigned, BytesToWrite,
                       FILE *, OutFile)
/* Write one scan line out using RLL compression */
{
  register unsigned OutPtr, RepCount, RepChar, MaxRepCount=63;

  OutPtr=0;			/* point to data to compress */
  do {
    RepChar=ScanLine[OutPtr++];	/* get byte */
    RepCount=1;			/* byte seen once at this point */
    while ( ScanLine[OutPtr]==RepChar &&
            RepCount<MaxRepCount &&
            OutPtr<BytesToWrite) {
      RepCount++; OutPtr++;
    }
    if ( RepCount>1 || RepChar>0xbf ) {
      RepCount |= 0xc0;		/* set two MSBs */
      fputc(RepCount,OutFile);
    }
    fputc(RepChar,OutFile);
  } while (OutPtr<BytesToWrite);
}
