/* $Id: bmf2img.c,v 1.2 2004/11/26 11:41:32 zlb Exp $ */

/* Transform a BMF file to PCX or TIFF format */
#ifndef IMGTYPE
#  define IMGTYPE	1		/* 0: TIFF, 1: PCX */
#endif

typedef unsigned char byte;

#define BUFFERLEN	8192

#if defined(UNIX) || defined(GO32)
#  include <stdio.h>
#  include <stdlib.h>
#  include <string.h>
#  include <ctype.h>
#else
#  include <stdio.h>
#  include <stdlib.h>
#ifdef WIN32
#  include <malloc.h>
#else
#  include <alloc.h>
#endif
#  include <string.h>
#ifdef WIN32
#  include <memory.h>
#else
#  include <mem.h>
#endif
#  include <ctype.h>
#endif

#include "proto.h"

#if IMGTYPE==0
#  include "bmf2tif.h"
#endif
#if IMGTYPE==1
#  include "bmf2pcx.h"
#endif

#include "bmf.inc"

int width,height;
long dpix,dpiy;

byte outname[256]="";
byte bmfname[256];
FILE *f_out;

byte *buffer;

int neg_flag=0, quiet=0;

int main _P2(int, argc, char **, argv)
{
  int i, j, widthb;
  int n;
  byte *p, b;

  f_out=NULL;

  if ((buffer=malloc(BUFFERLEN))==NULL) {
    fprintf(stderr,"Memory allocation error!"); goto fin;
  }

  for (i=1;i<argc;i++) {
    p=argv[i];
    if (*p=='-') {
      if (!*(++p)) continue;
      switch (toupper(*p)) {
	case 'N' :   /* negative */
          if (p[1]) goto error;
	  neg_flag=!neg_flag;
	  break;
	case 'Q' :   /* run quietly */
          if (p[1]) goto error;
	  quiet=!quiet;
	  break;
        default  :
     error:
          fprintf(stderr,"\nInvalid option \"%s\".\n",argv[i]);
          goto use;
      }
    } else {
      if (bmfname[0]) {
        fprintf(stderr,"\nToo many file names!\n"); goto use;
      }
      strncpy(bmfname,argv[i],255); bmfname[255]='\0';
    }
  }
  if (!bmfname[0]) {
    fprintf(stderr,"Transform a BMF file to PCX or TIFF format.\n");
  use:
    fprintf(stderr,"Usage:\n");
    fprintf(stderr,"\tbmf2pcx bmf_file_name [-n] [-q]\n");
    fprintf(stderr,"\tbmf2tif bmf_file_name [-n] [-q]\n");
    fprintf(stderr,"Switches:\n");
    fprintf(stderr,"\t-n	Reverse the image.\n");
    fprintf(stderr,"\t-q	Run quietly.\n");
    fprintf(stderr,"Examples:\n");
    fprintf(stderr,"\tbmf2pcx toto.bmf\n");
    fprintf(stderr,"\tbmf2tif toto.bmf\n");
    exit(1);
  }

#ifndef UNIX
  for (i=0;i<(int)strlen(bmfname);i++) if (bmfname[i]=='\\') bmfname[i]='/';
  strupr(bmfname);
#endif
  strcpy(outname,bmfname);
  i=strlen(outname)-1;
  for (;i>=0 && outname[i]!='.';i--);
  if (i>=0 && outname[i+1]!='/') outname[i]='\0';
  else strcat(bmfname,".bmf");
  AddFileExtension(outname);

  /* read BMF heading */
  if (bmf_open(bmfname,&dpix,&dpiy,&width,&height,&n,&n)==-1) {
    fprintf(stderr,"Can't open BMF file \"%s\"!\n",bmfname); goto fin;
  }

  if (!quiet) {
    fprintf(stderr,"width=%d, height=%d\n",width,height);
    fprintf(stderr,"Creating file \"%s\"...\n",outname);
  }

  if ((f_out=fopen(outname,"w+b"))==NULL) {
    fprintf(stderr,"Cannot open file \"%s\" for output!\n",outname); goto fin;
  }
  if (setvbuf(f_out,NULL,_IOFBF,31*1024)) {
    fprintf(stderr,"Cannot setup output buffer!\n"); goto fin;
  }

  /* write the data */
  widthb=(width+7)/8;

  /* write file header */
  WriteFileHeader(width,height,dpix,dpiy,f_out);

  b=(255<<(widthb*8-width)) & 255;
  for (i=0;i<height;i++) {
    bmf_get_line(i,buffer);
    if (neg_flag) {
      for (j=0,p=buffer;j<widthb-1;j++) *(p++)^=255;
      *p^=b;
    }
    WriteScanLine(buffer,widthb,f_out);
    if (!quiet) fprintf(stderr,"%d\r",i);
  }

  if (!quiet) fprintf(stderr,"Done.\n");
fin:
  if (f_out!=NULL) fclose(f_out);
  bmf_close();

  return 0;
}
