/* $Id: GBK-utils.c,v 1.3 2005/05/23 06:41:05 zlb Exp $
 *
 * Functions for comparing GBK characters */

#include <stdio.h>
#include <string.h>

#include "GBK-pinyin.h"
#include "GBK-strokes.h"
#include "GBK-utils.h"

typedef enum {False, True} Boolean;

static GBK_order_t ordering = GBK_STROKE;	/* default */

int
GBK_set_ordering(GBK_order_t order)
{
    switch (order) {
	case GBK_PINYIN:
	case GBK_STROKE:
	case GBK_MIXED:
	    ordering = order;
	    break;
	default:
	    fprintf(stderr, "GBK_set_ordering: unimplemented ordering %d.\n",
			    order);
	    return 1;
    }

    return 0;
}

GBK_order_t
GBK_get_ordering(void)
{
    return ordering;
}

static int
GBK_get_code(const unsigned char *gbk)
{
    /* chars in the follow string are mapped to '0', '1', 2', etc. */
    static char cctconv[] = "\\{}^_~\x80|";
    unsigned char c1 = *gbk, c2 = gbk[1];
    int i = c2 - '0';

    if (i < (sizeof(cctconv) - 1) && i >= 0)
	c2 = cctconv[i];
	

    return (c1 < 129 || c1 > 254 || c2 < 64 || c2 > 254 || c2 == 127) ?
	   -1 : (c1 - 129) * 190 + (c2 - 64) - (c2 > 127 ? 1 : 0);
}

int
GBK_char_comp(const unsigned char *gbk1, const unsigned char *gbk2)
{
    int i;
    int c1 = GBK_get_code(gbk1), c2 = GBK_get_code(gbk2);

    if (c1 < 0 ) return (c2 < 0) ? memcmp(gbk1, gbk2, 2) : -1;
    if (c2 < 0 ) return 1;

    switch (ordering) {
	case GBK_PINYIN:
	case GBK_MIXED:
	    if ((i = strcmp(pytable[c1], pytable[c2])) != 0)
		return i;
	    break;
	case GBK_STROKE:
	    if ((i = stroke_table[c1].len - stroke_table[c2].len) != 0)
		return i;
	    if ((i = strcmp(stroke_table[c1].strokes,
			    stroke_table[c2].strokes)) != 0)
		return i;
	    break;
    }

    return memcmp(gbk1, gbk2, 2);
}

static unsigned char *
GBK_number(unsigned n)
{
    static unsigned char buffer[128];
    unsigned m;

    switch (n) {
	case 0:  return ""; 
	case 1:  return "һ";
	case 2:  return "";
	case 3:  return "";
	case 4:  return "";
	case 5:  return "";
	case 6:  return "";
	case 7:  return "";
	case 8:  return "";
	case 9:  return "";
    }

    if (n <= 100) {
	switch (m = n/10) {
	    case 1:
		strcpy(buffer, "ʮ");
		break;
#if 0
	    case 2:
	        strcpy(buffer, "إ");
		break;
#endif
	    default:
		strcpy(buffer, GBK_number(m));
		strcat(buffer, "ʮ");
	}
	if ((m = n%10) != 0) strcat(buffer, GBK_number(m));
	return buffer;
    }

    /* case n > 100 to be implemented!!! */
    sprintf(buffer, "%d", n);
    return buffer;
}

void
GBK_get_initial(unsigned char *buffer, size_t buffersize,
		const unsigned char *gbk)
{
    unsigned char I[128];
    int c;

    if (buffersize <= 0) return;
   
    c = GBK_get_code(gbk);

    buffer[0] = '\0';
    if (c < 0) return;

    switch (ordering) {
	case GBK_PINYIN:
	case GBK_MIXED:
	    strncpy(buffer, pytable[c], buffersize);
	    break;
	case GBK_STROKE:
	    sprintf(I, "%s", GBK_number(stroke_table[c].len));
	    strncpy(buffer, I, buffersize);
	    break;
    }

    buffer[buffersize - 1] = '\0';
}
