/* $Id: url.c,v 1.2 2004/11/26 11:25:42 zlb Exp $ */

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <ctype.h>

typedef unsigned char byte;

static int
url_char(byte c, int email)
{
    if (c == '\0') return 0;
    if (!email && strchr("/?&#=", c) != NULL) return 1;
    if (isalpha(c) || isdigit(c)) return 1;
    if (strchr("_%$-~.?&#+", c) != NULL) return 1;
    return 0;
}

static int
parse_urls0(byte *str, const byte *a, const byte *tex_cs, int email,
		size_t str_size)
{
    byte *q0, *q1;
    size_t len_a = strlen(a), len = strlen(str), len_tex = strlen(tex_cs);
    int ret = 0;

    str_size -= len + 1;
    while (len > 0) {
	if ((q0 = strstr(str, a)) == NULL) break;
	q1 = q0 + len_a;
	while (url_char(*q1, email)) q1++;
	if (*(q1 - 1) == '.') q1--;
	while (q0 > str && url_char(*(q0 - 1), email)) q0--;
	/* check if already enclosed in '{ ... }' */
	if (q0 > str && *(q0 - 1) == '{' && *q1 == '}') {
	    len -= q1 - str;
	    str = q1;
	    continue;
	}
	str_size -= len_tex + 2;
	if (str_size < 0) {
	    fprintf(stderr, "url.c: error: insufficient buffer size!\n");
	    exit(1);
	}
	ret = 1;
	memmove(q1 + 2 + len_tex, q1, len - (q1 - str) + 1);
	*(q1 + 1 + len_tex) = '}';
	memmove(q0 + 1 + len_tex, q0, q1 - q0);
	memcpy(q0, tex_cs, len_tex);
	*(q0 + len_tex) = '{';
	len -= q1 - q0;
	str = q1 + 2 + len_tex;
    }

    return ret;
}

int
parse_urls(byte *str, size_t str_size)
{
    int ret = parse_urls0(str, "@", "\\email", 1, str_size);
    return parse_urls0(str, "://", "\\url", 0, str_size) || ret;
}

#ifdef TEST
int
main(int argc, char *argv[])
{
    byte line[8192];
    int ret;

    if (argc !=2) {
	fprintf(stderr, "Usage: test string\n");
	exit(1);
    }

    ret = parse_urls(strcpy(line, argv[1]), sizeof(line));
    printf("%s\n%s\n", ret ? "True" : "False", line);
}
#endif
