@echo off

@if A%3==A goto usage

@rem --- Run cctinit
@echo "Running cctinit.exe ..."
echo -H%1\tex\latex\cct -T%1\fonts\tfm\cct >"%1\cct\bin\cctinit.ini"
@if exist "%1\cct\bin\cct.dat" goto cctinit1
@echo Creating default "%1\cct\bin\cct.dat".
@copy "%1\tex\latex\cct\cct.dat-dist" "%1\cct\bin\cct.dat"
:cctinit1
"%1\cct\bin\cctinit"
@if errorlevel 1 pause

@rem --- Create cmap files
REM if not "%2A"=="A" cd "%2"


copy/y "%1\tex\latex\ccmap\makecmap.tex" . >nul
@if not exist "%2\tex\latex\ccmap\UGBK.sfd" goto cmap1
@echo "Generating %1\tex\latex\ccmap\c19\c19*.cmap ..."
del "%1\tex\latex\ccmap\c19??.cmap"
copy/y "%2\tex\latex\ccmap\UGBK.sfd" . >nul
latex \def\cmapEnc{GBK} \input{makecmap.tex}
mkdir "%1\tex\latex\ccmap\c19" >nul
move/y c19??.cmap "%1\tex\latex\ccmap\c19\." >nul
:cmap1
@if not exist "%2\tex\latex\ccmap\UGB.sfd" goto cmap2
@echo "Generating %1\tex\latex\ccmap\c10\c10*.cmap ..."
copy/y "%2\tex\latex\ccmap\UGB.sfd" . >nul
latex \def\cmapEnc{GB} \input{makecmap.tex}
mkdir "%1\tex\latex\ccmap\c10" >nul
move/y c10??.cmap "%1\tex\latex\ccmap\c10\." >nul
:cmap2
del makecmap.*
del ugbk.sfd
del ugb.sfd

@rem --- Add corners.pfb to configuration files
@rem if exist "%1\web2c\updmap.cfg" goto ???
@echo "Installing font corners.pfb ..."
"%1\cct\bin\addtocfg" "%3\miktex\config\updmap.cfg" "# For everb.sty" "Map corners.map"
@if errorlevel 1 pause

@rem --- Update map files and filenames database
@echo "Updating filenames database ..."
"%2\miktex\bin\initexmf" --update-fndb >nul
@if errorlevel 1 pause
@echo "Updating map files ..."
"%2\miktex\bin\initexmf" --mkmaps >nul
@if errorlevel 1 pause

@rem --- Create README.pdf and CCTLaTeX.pdf
set path=%1\cct\bin;%path%
cd "%1\cct\doc"
"%1\cct\bin\ctex" -dvipdfmx README.tex
del README.log >nul
del README.dvi >nul
"%1\cct\bin\ctex" -dvipdfmx CCTLaTeX.tex
del CCTLaTeX.log >nul
del CCTLaTeX.dvi >nul
"%1\cct\bin\ctex" -clean >nul
@goto end

:usage
@echo Usage:
@echo     cct-updt  cct-root texmfroot localtexmfroot
@echo Example:
@echo     cct-updt  C:\ctex\localtexmf C:\ctex\texmf 

:end
pause
