%define ver 0.618
%define rel 6
%define texmf %{prefix}/share/texmf

Summary:	CCT v%{ver}-%{rel} for RedHat Linux
Version: 	%ver
Release:	%rel
Name:		cct
#Requires:	CJK-GBKfonts >= 0.3-7
Requires:	tetex tetex-fonts tetex-latex cct-fonts gawk
#Requires:	tetex-xdvi tetex-dvips
# -- cctpace.c requires the kpse headers and libs
#BuildRequires:	tetex fontforge
BuildRequires:	tetex
# -- 'cct-redhat6x' is the name used in old CCT packages
Provides:	cct-redhat6x cct
Group:		Applications/Publishing
Source:		cct-%{ver}-%{rel}.tar.bz2
URL:		ftp://lsec.cc.ac.cn/pub/cct
Packager:	Zhang Lin-bo <zlb@lsec.cc.ac.cn>
License:	non-commercial use
BuildRoot:	/var/tmp/cct-%{ver}-root
Prefix:		/usr

%description

CCT is a set of programs which adds Chinese support to
an existing TeX system. This package is designed to work
with RedHat teTeX distribution.

This RPM distribution contains cct-0.618, ctex-0.2.9, addr2tex-20050628,
CCTfntef-4.5.3-4b, and ccmap.

%prep
%setup -q -n cct-dist

%build
if env LANG=C gcc -v 2>&1 | grep -q 'gcc version 4'; then
    make EXTRA_CFLAGS=-Wno-pointer-sign all
else
    make all
fi

%install
rm -rf $RPM_BUILD_ROOT
make prefix=%{prefix} install_root=$RPM_BUILD_ROOT install

%clean
rm -rf $RPM_BUILD_ROOT

%pre

%post

cctinit >/dev/null 2>&1

if test -d %{texmf}/fonts/map/dvips; then
    rm -f %{texmf}/fonts/map/dvips/cct
    ln -s ../../../dvips/cct %{texmf}/fonts/map/dvips/.
fi

if test -d %{texmf}/fonts/enc/dvips; then
    rm -f %{texmf}/fonts/enc/dvips/cct
    ln -s ../../../dvips/cct %{texmf}/fonts/enc/dvips/.
fi

for e in "GBK c19" "GB c10"; do
    set -- $e
    (
	mkdir -p /tmp/cct.tmp.$$
	cd /tmp/cct.tmp.$$
	ln -sf %{texmf}/tex/latex/ccmap/U$1.sfd .
	ln -sf %{texmf}/tex/latex/ccmap/makecmap.tex .
	latex '\def\cmapEnc{'$1'} \input{makecmap.tex}' >/dev/null 2>&1
	mkdir -p %{texmf}/tex/latex/ccmap/$2
	mv ${2}??.cmap %{texmf}/tex/latex/ccmap/${2}/.
	cd ..
	/bin/rm -rf /tmp/cct.tmp.$$ %{texmf}/tex/latex/ccmap/${2}??.cmap
    )
done

texhash %{texmf}
if true; then
  for f in psfonts.map pdftex.map; do
    map=`kpsewhich -format=map $f`
    test -n "$map" || map=%{texmf}/dvips/config/$f
    if test -r $map && ! grep -q '^corners ' $map; then
    	echo 'corners corners <corners.pfb' >>$map
    fi
  done
else
  if ! grep -q '^Map corners.map' %{texmf}/web2c/updmap.cfg; then
    echo >>%{texmf}/web2c/updmap.cfg
    echo "# For everb.sty" >>%{texmf}/web2c/updmap.cfg
    echo "Map corners.map" >>%{texmf}/web2c/updmap.cfg
  fi
  if test -x %{prefix}/bin/updmap; then
    if %{prefix}/bin/updmap --help | grep -q dvipsoutputdir && \
	test -d %{texmf}/fonts/map; then
	%{prefix}/bin/updmap --quiet \
		--dvipsoutputdir %{texmf}/fonts/map/dvips/updmap \
		--dvipdfmoutputdir %{texmf}/fonts/map/dvipdfm/updmap \
		--pdftexoutputdir %{texmf}/fonts/map/pdftex/updmap
    else
	%{prefix}/bin/updmap --quiet
    fi
  fi
fi
texhash %{texmf}

%preun
# Note: these commands seem to be executed after 'post', thus
#	they may remove the newly created files when upgrading.
#rm -f %{prefix}/share/texmf/tex/cct/cchead.sty \
#	%{prefix}/share/texmf/fonts/tfm/cct/cc{fnt[a-z],dummy}.tfm \
#	%{prefix}/share/texmf/fonts/cct/pk/*
#texhash %{prefix}/share/texmf

%postun
test -L %{texmf}/fonts/map/dvips/cct && rm -f %{texmf}/fonts/map/dvips/cct
test -L %{texmf}/fonts/enc/dvips/cct && rm -f %{texmf}/fonts/enc/dvips/cct
texhash %{texmf}

%files
%defattr(-,root,root)
%dir %{prefix}/share/texmf/fonts/tfm/cct
%config %{prefix}/bin/cct.ini
%config %{prefix}/bin/cctinit.ini
%config %{prefix}/share/texmf/tex/cct/CCT.cfg
%config %{prefix}/share/texmf/tex/cct/CCT047.cfg
%config %{prefix}/share/texmf/tex/cct/cctspace.cfg
%config %{prefix}/share/texmf/tex/cct/cct.dat
%config %{prefix}/share/texmf/tex/cct/GBKkern.cfg
%config %{prefix}/share/texmf/tex/cct/clib256e.tbl
%config %{prefix}/share/texmf/tex/cct/gbkdef.tbl
%config %{prefix}/share/texmf/tex/cct/gbksong.tbl
%config %{prefix}/share/texmf/tex/cct/gbkhei.tbl
%config %{prefix}/share/texmf/tex/cct/gbkkai.tbl
%config %{prefix}/share/texmf/tex/cct/gbkfs.tbl
%config %{prefix}/share/texmf/tex/cct/gbkbs.tbl
%config %{prefix}/share/texmf/tex/cct/gbkli.tbl
%config %{prefix}/share/texmf/tex/cct/gbkyou.tbl
%config %{prefix}/share/texmf/tex/cct/addr2tex.sty
%config %{prefix}/share/texmf/tex/latex/ccmap/ccmap.sty
%config %{prefix}/share/texmf/tex/latex/ccmap/makecmap.tex
%{prefix}/bin/bmf2pcx
%{prefix}/bin/bmf2tif
%{prefix}/bin/cct
%{prefix}/bin/cctamstex
%{prefix}/bin/cctconv
%{prefix}/bin/cctinit
%{prefix}/bin/cctlatex
%{prefix}/bin/cctpdflatex
%{prefix}/bin/cctpdftex
%{prefix}/bin/cctspace
%{prefix}/bin/ccttex
%{prefix}/bin/ctex
%{prefix}/bin/dvipsc
%{prefix}/bin/gbk2uni
%{prefix}/bin/patchchk
%{prefix}/bin/patchdvi
%{prefix}/bin/text2dvi
%{prefix}/bin/uncct
%{prefix}/bin/xdvic
%{prefix}/bin/eps2pdf
%{prefix}/bin/fonttest
%{prefix}/bin/charcnt
%{prefix}/bin/GBKpunct
%{prefix}/bin/addr2tex
%{prefix}/bin/gb2wncyr
%{prefix}/bin/cctmkind
%{prefix}/share/doc/cct/*
%{prefix}/share/texmf/tex/cct/CCT.sty
%{prefix}/share/texmf/tex/cct/CCT047.sty
%{prefix}/share/texmf/tex/cct/CJKCCT.sty
%{prefix}/share/texmf/tex/cct/cctart.cls
%{prefix}/share/texmf/tex/cct/cctbase.sty
%{prefix}/share/texmf/tex/cct/cctbook.cls
%{prefix}/share/texmf/tex/cct/hzcmd.sty
%{prefix}/share/texmf/tex/cct/CCTty.sty
%{prefix}/share/texmf/tex/cct/everb.sty
%{prefix}/share/texmf/tex/cct/CCTfntef.sty
%{prefix}/share/texmf/makeindex/cct/cct.ist
%{prefix}/share/texmf/makeindex/cct/cctglo.ist
%{prefix}/share/texmf/fonts/tfm/cct/corners.tfm
%{prefix}/share/texmf/fonts/afm/cct/corners.afm
%{prefix}/share/texmf/fonts/type1/cct/corners.pfb
%{prefix}/share/texmf/fonts/truetype/cct/corners.ttf
%{prefix}/share/texmf/dvips/cct/corners.enc
%{prefix}/share/texmf/dvips/cct/corners.map
%{prefix}/share/texmf/tex/latex/ccmap/UGB.sfd
%{prefix}/share/texmf/tex/latex/ccmap/UGBK.sfd

%changelog

* Sat Jul  9 2005 Zhang Linbo <zlb@lsec.cc.ac.cn>

- CCT-0.618-6: fixes for teTeX-3 and gcc4

* Mon Dec 13 2004 Zhang Linbo <zlb@lsec.cc.ac.cn>

- CCT 0.618-0 (added 'corners' font)

* Fri Dec  3 2004 Zhang Linbo <zlb@lsec.cc.ac.cn>

- CCT 0.61-2

- ccmap.sty and *.cmap files

* Mon Oct  4 2004 Zhang Linbo <zlb@lsec.cc.ac.cn>

- CCT 0.61, ctex 0.2.6, everb 0.1.7, etc.,

- add files TEXMF/makeindex/cct/{cct.ist,cctglo.ist}

* Sat Aug 14 2004 Zhang Linbo <zlb@lsec.cc.ac.cn>

- everb.sty 0.1.6

* Sat Jul 24 2004 Zhang Linbo <zlb@lsec.cc.ac.cn>

- Add add2tex

- ctex-0.2.5

* Thu Mar 18 2004 Zhang Linbo <zlb@lsec.cc.ac.cn>

- Add everb.sty

- The package made relocatable (rpm --prefix ...)

* Thu Feb 12 2004 Zhang Linbo <zlb@lsec.cc.ac.cn>

- Add /usr/share/texmf/tex/cct/gbk{li,you}.tbl

* Sat Dec 20 2003 Zhang Linbo <zlb@lsec.cc.ac.cn>

- Add files /usr/share/doc/cct/CCTLaTeX.{tex,pdf}

* Sun Aug 24 2003 Zhang Linbo <zlb@lsec.cc.ac.cn>

- Upgrade to CCT.sty 0.6.0

- Lines containing 'CCTdebug' removed from CCT.sty in the distribution

* Thu Aug 14 2003 Zhang Linbo <zlb@lsec.cc.ac.cn>

- CCT.sty upgraded to 0.4.7

* Fri Aug 08 2003 Zhang Linbo <zlb@lsec.cc.ac.cn>

- xdvic: '-nofork' option removed for compatibility with older versions
  of xdvik.

* Sat Jun 21 2003 Zhang Linbo <zlb@lsec.cc.ac.cn>

- ctex 0.2.1 (source filenames in .log and .dvi files are automatically
  restored)

* Mon Apr 21 2003 Zhang Linbo <zlb@lsec.cc.ac.cn>

- preun: keep the files 'cchead.sty', 'ccdummy.tfm', and 'ccfnt*.tfm',
  (otherwise the newly generated files will be removed when upgrading).

  Note: need to run 'rpm -Uvh --force cct*.rpm' twice if upgrading from
  an older version of cct.

* Thu Mar 06 2003 Zhang Linbo <zlb@lsec.cc.ac.cn>

- create src.rpm

- new versions of cct, cctinit, cctspace, cctconv, and patchdvi
  (minor bug fixes and enhancements).

- replace the 'cct*tex' scripts with symbolic links to 'ctex'.

* Mon Jan 30 2003 Zhang Linbo <zlb@lsec.cc.ac.cn>

- cct, cctinit upgraded to v5.15 (the new version does
  not insert spaces before or after '~')

- new cctart.cls and cctbook.cls based on CCT.sty

