#!/bin/sh
#
# Edit the paths below
#LIBDIR=/usr/lib/teTeX/texmf	# teTeX
LIBDIR=/usr/local/lib/texmf
#=========== where to put the binaries
#BINDIR=/usr/lib/teTeX/bin	# teTeX
BINDIR=/usr/local/bin

#=========== where to put tmp PK fonts
PKDIR=${LIBDIR}/fonts/cct/pk
#=========== where to put the Chinese fonts
HZDIR=${LIBDIR}/fonts/cct/hzfonts
#=========== where to put the "ccfnt*.tfm" files
TFMDIR=${LIBDIR}/fonts/cct/tfm
#=========== where to put cchead.sty and cct.dat
TEXDIR=${LIBDIR}/tex/cct

./mkdirch.sh $BINDIR
./mkdirch.sh $PKDIR; chmod 777 $PKDIR
./mkdirch.sh $HZDIR
./mkdirch.sh $TFMDIR
./mkdirch.sh $TEXDIR

#=========== Copy binaries
cp cct cct.ini cctinit patchdvi bmf2pcx bmf2tif ${BINDIR}/.
echo -n "Enter default resolution for xdvi and dvips (600): "
read DPI
if [ "$DPI" = "" ]
then 
  DPI=600
fi
sed -e "s:%PKDIR%:${PKDIR}:g" xdvic.in | sed -e "s:%HZDIR%:${HZDIR}:g" \
	| sed -e "s:%DPI%:${DPI}:g" > ${BINDIR}/xdvic
sed -e "s:%PKDIR%:${PKDIR}:g" dvipsc.in | sed -e "s:%HZDIR%:${HZDIR}:g" \
	| sed -e "s:%DPI%:${DPI}:g" > ${BINDIR}/dvipsc
chmod 755 ${BINDIR}/dvipsc ${BINDIR}/xdvic
#=========== Copy cct.dat
cp cct.dat ${TEXDIR}/.
#=========== Copy Chinese fonts
if [ ! -f hzfonts/ccfonts.def ]
then
  echo "!-----------------------------------------------------------!"
  echo "! Cannot find PPS fonts. You should download \"fonts.tar.gz\" !"
  echo "!-----------------------------------------------------------!"
  echo "Press Enter to continue..."
  read dummy
else
  echo Installing PPS fonts...
  cp hzfonts/* ${HZDIR}/.
fi

#=========== Execute cctinit
echo "-t$TFMDIR -h$TEXDIR" > ${BINDIR}/cctinit.ini
./cctinit -t$TFMDIR -h$TEXDIR

#=========== Create LaTeX2e document classes for CCT
./cct cctbase.ctx ${TEXDIR}/cctbase.sty
./cct cctbook.ctx ${TEXDIR}/cctbook.cls
./cct cctart.ctx ${TEXDIR}/cctart.cls
